/****************************************************************************
**
** Copyright (C) 1992-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the QtOpenGL module of the Qt Toolkit.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include "private/qscreengl_p.h"
#include <QGLContext>
#include <QGLWidget>
#include "private/qwindowsurface_gl_p.h"

class QGLScreenPrivate
{

};

QGLScreen::QGLScreen(int displayId)
    : QScreen(displayId), d_ptr(new QGLScreenPrivate)
{
}

QGLScreen::~QGLScreen()
{
    delete d_ptr;
}

/*!
    \since 4.3

    Initializes the \a context and sets up the QGLWindowSurface of the QWidget of \a context
    based on the parameters of \a context and based on its own requirements.
    The format() of \a context needs to be updated with the
    actual parameters of the OpenGLES drawable that was set up.

    \a shareContext is used in the same way as for QGLContext. It is the context with which \a context
    shares display lists and texture ids etc. The window surface must be set up so that this sharing works.

    returns true in case of success and false if it is not possible to create the necessary OpenGLES
    drawable/context.
*/
bool QGLScreen::chooseContext(QGLContext *context, const QGLContext *shareContext)
{
    QGLWidget *widget = static_cast<QGLWidget*>(context->device());
    if (context->device()->devType() == QInternal::Widget) {
        QGLWindowSurface *surface = static_cast<QGLWindowSurface*>(widget->windowSurface());
        surface->setContext(context);
        return true;
    }
    return false;
}
