/* 
*  File      : winlist.cpp
*  Written by: alinden@gmx.de
*  Copyright : GPL
*
*  Creates the winlist button
*/

#include "defs.h"
#include "defaults.h"
#include "qapp.h"
#include "winlist.h"

winlist::winlist(QWidget *parent, const char *name) : QPushButton(parent, name)
{
	setFixedSize(defaults::tc_height, defaults::tc_height);
	wmenu = new QPopupMenu(this);
	CHECK_PTR(wmenu);
	QImage img(qapp::get_cfile("winlist.xpm"));

	if(! img.isNull())  // scale pixmap
	{
		int wh = defaults::tc_height-4;
		QPixmap pix;
		pix.convertFromImage(img.smoothScale(wh, wh));
		setPixmap(pix);
	}
}

// returns TRUE if client is fully obscured by other toplevel windows

bool winlist::isobscured(xwindow *client)
{
	Window w1,w2,*wins;
	uint nwins,cwin;
	xwindow *nclient;

	if(XQueryTree(qt_xdisplay(), qt_xrootwin(), &w1, &w2, &wins, &nwins) == 0 || ! nwins)
		return FALSE;

	for(cwin=0; cwin < nwins; cwin++)  // find current window
		if(wins[cwin] == client->winId())
			break;

	if(cwin >= nwins)
		return FALSE;

	QRegion sr(client->frameGeometry());
	
	while(++cwin < nwins)
	{
		if((nclient = qapp::pwindows.find(wins[cwin])) == NULL || ! nclient->isVisible())
			continue;
		
		sr -= QRegion(nclient->frameGeometry());

		if(sr.isEmpty())
		{
			XFree(wins);
			return TRUE;
		}	
	}
	XFree(wins);
	
	return FALSE;
}

void winlist::mouseReleaseEvent(QMouseEvent *event)
{
	if(event->button() == QMouseEvent::RightButton)
		setDown(FALSE);
}

void winlist::mousePressEvent(QMouseEvent *event)
{
	xwindow *win;
	
	if(event->button() == QMouseEvent::RightButton)  // hidden to foreground
	{
		setDown(TRUE);
		hidden_win();
	}
	else if(event->button() == QMouseEvent::LeftButton && ! isDown())
		start_popup();
}

void winlist::hidden_win(void)
{
	xwindow *win;
	QList <xwindow> wlist = qapp::clients;
	
	int dwidth = QApplication::desktop()->width();

	for(win = wlist.last(); win != NULL; win = wlist.prev())
	{
		if(win->isVisible() && win->x() <= dwidth && win->x() >= 0 && isobscured(win))
		{
			win->raise();
			break;
		}	
	}
}

void winlist::start_popup(void)
{
	QList <xwindow> wlist = qapp::clients;
	setDown(TRUE);
	popup_list(wlist);
}

void winlist::popup_list(QList <xwindow> &wlist)
{
	xwindow *win;
	QString wname;
	Window rw,cw;
	int rx,ry,wx,wy;
	unsigned mr;

	for(win = wlist.first(); win != NULL; win = wlist.next())
	{
		if(win->get_pflags() & qapp::WindowListSkip || win->iswithdrawn())
			continue;

		wname = win->ccaption().left(100);

		if(! win->isVisible())
		{
			wname.prepend('<');
			wname.append('>');
		}
		
		if(! win->getmachine().isNull())
		{
			wname += " (";
			wname += win->getmachine().left(20);
			wname += ')';
		}	
		wmenu->insertItem(wname, win, SLOT(focus_mouse()));
	}

	if(! defaults::show_winlist || qapp::smode)  // show at mouse position
	{
		XQueryPointer(qt_xdisplay(), qt_xrootwin(), &rw, &cw, &rx, &ry, &wx, &wy, &mr);
		wmenu->exec(QPoint(rx, ry));
	}
	else
	{
		if(! defaults::toolbar_top)   // menu above button
		{
			QPoint p = mapToGlobal(QPoint(0, 0));
			QSize s(wmenu->sizeHint());
			p.setY(p.y()-s.height());
			wmenu->exec(p);
		}
		else
			wmenu->exec(mapToGlobal(QPoint(0, height())));
	}		
		
	wmenu->clear();
	setDown(FALSE);
}
