/*
*  File     : toolbar.cpp
*  Writen by: alinden@gmx.de
*  Copyright: GPL
*
*  Draw the toolbar and place items on it
*/

#include "defs.h"
#include "toolbar.h"

Toolbar::Toolbar(QWidget *parent, const char *name) : QFrame(parent, name)
{
	layout = new QHBoxLayout(this);
	layout->setSpacing(1);
	
	setFrameStyle(QFrame::Panel|QFrame::Raised);
	setLineWidth(1);
}

void Toolbar::add(QWidget *item)
{
	layout->add(item);
	item->show();
}

void Toolbar::addspacing(int space)
{
	layout->addSpacing(space);
}

void Toolbar::addsep(void)
{
	layout->addSpacing(3);
	QFrame *frame = new QFrame(this);
	frame->setLineWidth(1);
	frame->setMidLineWidth(0);
	frame->setFrameStyle(QFrame::VLine|QFrame::Sunken);
	frame->setFixedHeight(height()-4);
	layout->addWidget(frame);
	layout->addSpacing(3);
}
