//////////////////////////////////////////////////////////////////////////////
// bitmaps.h
// -------------------
// Qinx window decoration bitmaps
// -------------------
// Copyright (c) 2002-2004 David Johnson <david@usermode.org>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//////////////////////////////////////////////////////////////////////////////

#ifndef BITMAPS_H
#define BITMAPS_H

namespace Qinx {

// bitmaps for large buttons (11x11)

static const unsigned char max_dark[] = {
   0x00, 0x00, 0x00, 0x04, 0xfe, 0x07, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04,
   0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0xfe, 0x07};
static const unsigned char max_mid[] = {
   0x00, 0x04, 0x00, 0x00, 0x01, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00};
static const unsigned char max_light[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x03, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static const unsigned char restore_shadow[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00,
   0x70, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static const unsigned char min_shadow[] = {
   0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x70, 0x00, 0x20, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char min_dark[] = {
   0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04,
   0x00, 0x04, 0xfe, 0x07, 0x00, 0x00, 0x00, 0x04, 0xfe, 0x07};
static const unsigned char min_mid[] = {
   0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x01, 0x00, 0x00, 0x04, 0x00, 0x00, 0x01, 0x00};
static const unsigned char min_light[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xfe, 0x03, 0x00, 0x00, 0x00, 0x00};

static const unsigned char close_shadow[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x88, 0x00, 0x88, 0x00,
   0x88, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char close_dark[] = {
   0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x04, 0x00, 0x04, 0x00, 0x44, 0x00,
   0x64, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char close_mid[] = {
   0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x20, 0x00,
   0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00};
static const unsigned char close_light[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
   0x00, 0x01, 0x00, 0x01, 0xf8, 0x01, 0x00, 0x00, 0x00, 0x00};

static const unsigned char menu_dark[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x07, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xfe, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char menu_mid[] = {
   0x00, 0x00, 0x00, 0x00, 0xfe, 0x03, 0x01, 0x00, 0x00, 0x04, 0x00, 0x00,
   0xfe, 0x03, 0x01, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00};
static const unsigned char menu_light[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x07, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00};

static const unsigned char help_shadow[] = {
   0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, 0x80, 0x00, 0x40, 0x00,
   0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char help_mid[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static const unsigned char stickyup_shadow[] = {
   0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, 0x04, 0x01, 0x04, 0x01,
   0x04, 0x01, 0x88, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char stickyup_mid[] = {
   0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x04, 0x01, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x01, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00};

static const unsigned char stickydown_shadow[] = {
   0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x88, 0x00, 0x24, 0x01, 0x74, 0x01,
   0x24, 0x01, 0x88, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char stickydown_mid[] = {
   0x00, 0x00, 0x00, 0x00, 0x88, 0x00, 0x04, 0x01, 0x50, 0x00, 0x00, 0x00,
   0x50, 0x00, 0x04, 0x01, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00};

// bitmaps for small buttons (12x12)

static const unsigned char smax_dark[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x03, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char smax_mid[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char smax_light[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static const unsigned char smin_dark[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char smin_mid[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char smin_light[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static const unsigned char sclose_shadow[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00,
   0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char sclose_dark[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x10, 0x00,
   0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char sclose_light[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00,
   0x80, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static const unsigned char smenu_dark[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x03, 0x00, 0x00,
   0x00, 0x00, 0xfc, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char smenu_mid[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02,
   0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0xf8, 0x03, 0x00, 0x00, 0x00, 0x00};
static const unsigned char smenu_light[] = {
   0x00, 0x00, 0x00, 0x00, 0xfc, 0x01, 0x04, 0x00, 0x00, 0x00, 0xfc, 0x01,
   0x04, 0x00, 0x00, 0x00, 0xfc, 0x01, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00};

static const unsigned char shelp_shadow[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0xa0, 0x00, 0x80, 0x00,
   0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char shelp_mid[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static const unsigned char sstickyup_shadow[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x90, 0x00, 0x08, 0x01,
   0x08, 0x01, 0x90, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char sstickyup_mid[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x08, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x08, 0x01, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

static const unsigned char sstickydown_shadow[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0x90, 0x00, 0x68, 0x01,
   0x68, 0x01, 0x90, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const unsigned char sstickydown_mid[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x08, 0x01, 0x00, 0x00,
   0x00, 0x00, 0x08, 0x01, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

// decos constructed from above

static const ButtonDeco maxdeco = {
    false, 0, max_dark, max_mid, max_light};

static const ButtonDeco smallmaxdeco = {
    true, 0, smax_dark, smax_mid, smax_light};

static const ButtonDeco restoredeco = {
    false, restore_shadow, max_dark, max_mid, max_light};

static const ButtonDeco smallrestoredeco = {
    true, 0, smax_dark, smax_mid, smax_light};

static const ButtonDeco mindeco = {
    false, min_shadow, min_dark, min_mid, min_light};

static const ButtonDeco smallmindeco = {
    true, 0, smin_dark, smin_mid, smin_light};

static const ButtonDeco closedeco = {
    false, close_shadow, close_dark, close_mid, close_light};

static const ButtonDeco smallclosedeco = {
    true, sclose_shadow, sclose_dark, 0, sclose_light};

static const ButtonDeco menudeco = {
    false, 0, menu_dark, menu_mid, menu_light};

static const ButtonDeco smallmenudeco = {
    true, 0, smenu_dark, smenu_mid, smenu_light};

static const ButtonDeco helpdeco = {
    false, help_shadow, 0, help_mid, 0};

static const ButtonDeco smallhelpdeco = {
    false, shelp_shadow, 0, shelp_mid, 0};

static const ButtonDeco stickyupdeco = {
    false, stickyup_shadow, 0, stickyup_mid, 0};

static const ButtonDeco smallstickyupdeco = {
    false, sstickyup_shadow, 0, sstickyup_mid, 0};

static const ButtonDeco stickydowndeco = {
    false, stickydown_shadow, 0, stickydown_mid, 0};

static const ButtonDeco smallstickydowndeco = {
    false, sstickydown_shadow, 0, sstickydown_mid, 0};

} // namespace Qinx

#endif // BITMAPS_H
