/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

#ifndef _TRANSACTION_H
#define _TRANSACTION_H

#include "qhaccvector.h"

#include <iostream.h>

#include <qobject.h>
#include <qstring.h>
#include <qdatetime.h>

class Account;
class Transaction;
class QHaccAccountManager;

class Transaction : public QObject{
  Q_OBJECT

 public:
  Transaction( QDate =QDate::currentDate(), QString =QString(),
	       QString =QString(), QString =QString(), float =0 );
  Transaction( const Transaction& );
  Transaction( QString );
  virtual ~Transaction();

  const static int NUM, PAYEE, MEMO;
  enum RecoType { NO, MAYBE, YES };
  
  const QString get( int ) const;
  QDate getDate() const;
  RecoType getReconciled() const;
  float getSum() const ;
  unsigned int getID() const;
  Account * getAccount() const;
  QHaccVector getSplits() const;
  
  bool isSplit() const;
  bool isSingle() const;
  bool isReconciled( RecoType =YES ) const;

  void addSplit( Transaction * );
  void addSplits( QHaccVector& );
  void dropSplits();
  void clearSplits();
  virtual void load( QHaccAccountManager * );

  virtual QString getWriteableString() const;
  virtual QString getPairAName( ) const;
  virtual QString getPairAFName( ) const;
  virtual void set( int, QString );
  virtual void setDate( QDate );
  virtual void setSum( float );
  virtual void setAll( const Transaction * );
  void setReconciled( RecoType =YES );
  void setAccount( Account * );
  void removeYourself();
  
 protected:
  const static int INFOARRAYSIZE;
  
  QString * info; //all the text stuff
  QDate date;
  RecoType reco;
  float sum;

  // need the following vars for loading only
  unsigned int * loadArr;
  int loadArrSize;
  
 private:
  static unsigned int NEXTID;
  unsigned int id;
  QHaccVector splits;
  Account * owner;
  void init( QString, QString, QString );

 signals:
  void dateChanged();
  void balanceChanged( float, float );
  void infoChanged();
  void recChanged();
};


class MemorizedTransaction : public Transaction{
  Q_OBJECT
    public:
  MemorizedTransaction( const QString& );
  void load( QHaccAccountManager * );

};
#endif
