/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999 Ryan F Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCVIEW_H
#define _QHACCVIEW_H

#include "prefs.h"
#include "qhaccvector.h"

#include <qcolor.h>
#include <qframe.h>
#include <qwidget.h>

class Account;
class QPainter;
class QScrollBar;
class QPopupMenu;
class Transaction;

class QHaccView : public QFrame{
  Q_OBJECT
    public:
  QHaccView( Account * =0, QWidget * =0, const char * =0 );
  virtual ~QHaccView();

  void setAccount( Account * );

 protected:
  int lineSize, numViewableLines, numTrans, lines, pasteID1, pasteID2;
  const Prefs * prefs;

  void setAcctPop( QPopupMenu * );
  void setTransPop( QPopupMenu * );
  void resizeEvent( QResizeEvent * );
  void keyReleaseEvent( QKeyEvent * );
  void focusInEvent( QFocusEvent * );
  void focusOutEvent( QFocusEvent * );
  void mouseMoveEvent( QMouseEvent * );
  void mousePressEvent( QMouseEvent * );
  void mouseReleaseEvent( QMouseEvent * );
  virtual int spacePressed();
  virtual int delPressed();
  virtual int downPressed();  
  virtual int upPressed();

  virtual void drawTrans( const Transaction *, QPainter *, int, int );
  virtual Transaction * getTrans( int =-1 ) const;
  void drawContents( QPainter * );
  int getHeight() const;
  int getUseableWidth() const;
  int lineSpacing() const;
  void setIndex ( int );
  int getIndex() const;
  virtual int getNumTrans() const;
  Account * getAccount() const;
  bool hasTrans() const;

  QScrollBar * scroller;

 private:
  int currIndex;
  QPopupMenu * transPop, * acctPop, * memPop;
  Account * account;
  Transaction * copyTemp;

  public slots:
    virtual void refresh();
  virtual void recTrans();
  void accountOpened( Account * );
  void setLines( int );
  void remTrans();
  void editTrans();
  void newTrans();
  void memTrans();
  void addMemTrans( int );
  void pasteTrans();
  void copyTrans();
  void vrepaint();
  void newPrefs();
  void report();
  void chart();

 signals:
  void changePrefs();
  void editTrans( bool, Transaction *, const QRect& );
  void editSplitTrans( bool, Transaction *, const QRect& );
};

class QHaccRecView : public QHaccView{
  Q_OBJECT
    public:
  QHaccRecView( Account * =0, QWidget * =0, const char * =0 );
  ~QHaccRecView();
  void setDate( QDate );
  
 protected:
  Transaction * getTrans( int =-1 ) const;
  void mouseReleaseEvent( QMouseEvent * );
  void drawTrans( const Transaction *, QPainter *, int, int );
  int getNumTrans() const;  

  public slots:
    void refresh();
  void recTrans();
  int spacePressed();
  void addedTrans( Transaction * );

 private:
  QHaccVector trans;
  QDate limit;

 signals:
  void changeTrans( QHaccVector, float, float );
};

#endif
