/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCVECTOR_H
#define _QHACCVECTOR_H

#include <qobject.h>
#include <qdatetime.h>

class Transaction;

class QHaccVector : public QObject {
  Q_OBJECT
 public:
  QHaccVector( int =5, int =5, int =10 );
  QHaccVector( const QHaccVector& );
  const QHaccVector& operator=( const QHaccVector& );
  ~QHaccVector();
  
  int length( QDate, QDate =QDate() ) const;
  int length() const;
  Transaction * getTrans( int ) const;
  Transaction * find( unsigned int ) const;
  void add( Transaction * );
  bool remove( int );
  bool remove( Transaction * );
  bool contains( Transaction * ) const;
  int index( const Transaction * ) const;
  void startLoad( int i=0 );
  void stopLoad();
  void setLimits( int, int );
  void setNosort( bool );
  void sortOnName( bool );
  int getMaxFree() const;
  int getGrowth() const;
  bool isEmpty() const;
  void clear();
  QHaccVector getSubset( QDate, QDate ) const;

 private:
  // the following three functions do a quicksort on the array
  void resort( int, int );
  int findQ( int, int );
  void swap( int, int );
  bool compare( bool, const Transaction *, QString, QDate ) const;
  Transaction ** trans;
  int topIndex, maxFree, arrSize, growth;
  bool loading, nosort, namesort;

  protected slots:
    void resort();
};

#endif
