/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan F Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCLOADER_
#define _QHACCLOADER_

#include <qstring.h>
#include <qdatetime.h>
#include <qtextstream.h>

class QHaccLoader{
 public:
  static bool loadEngine( const char * );
  static bool saveEngine( const char *, QTextStream& );
  static QString saveAccounts( const char *, bool =false );
  static QString getConfigName( const char * );
  
  static void prune( const char *, QDate );
  static void restore( const char * );

 private:
  static void loadAccounts( const QString&, const char * );
  static void loadTrans( QHaccAccountManager *, unsigned int *,
			 const QString *, const char *, int );
};



#endif
