/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#include "accounts.h"
#include "qhaccacctman.h"

#include <qstrlist.h>


QHaccAccountManager * QHaccAccountManager::getInstance(){
  if ( !instance ) instance=new QHaccAccountManager();
  return instance;
}

QHaccAccountManager * QHaccAccountManager::instance=0;

QHaccAccountManager::QHaccAccountManager(){
  accounts=0;
  numAccounts=0;
}

QHaccAccountManager::~QHaccAccountManager(){
  for ( int i=0; i<numAccounts; i++ ) delete accounts[i];
  delete [] accounts;
}

QStrList QHaccAccountManager::getNames() const {
  QStrList returner;
  for ( int i=0; i<numAccounts; i++ )
    returner.append( accounts[i]->getName() );
  return returner;
}

QStrList QHaccAccountManager::getFullNames() const {
  QStrList returner;
  for ( int i=0; i<numAccounts; i++ )
    returner.append( accounts[i]->getName( Account::FULL ) );
  return returner;
}

void QHaccAccountManager::load( Account ** accts, int nA ){
  // wholesale adding of new accounts. Use this during the
  // initial load from savefiles
  if ( accounts ) delete [] accounts;  
  numAccounts=nA;
  accounts=new Account * [nA];
  for ( int i=0;i<nA; i++){
    accounts[i]=accts[i];
    connect ( accounts[i], SIGNAL( changedParent() ), SLOT( resort() ) );
  }
  resort();

  // NOTICE: doesn't emit a signal
}

bool QHaccAccountManager::isEmpty() const{ return ( numAccounts==0 );}
int QHaccAccountManager::count() const { return numAccounts; }
void QHaccAccountManager::add( Account * newAcct ) {
  if ( !newAcct || index( newAcct )>=0 ) return;
 
  Account ** newArr=new Account * [numAccounts+1];
  for ( int i=0;i<numAccounts; i++) newArr[i]=accounts[i];
  newArr[numAccounts++]=newAcct;
  delete [] accounts;
  accounts=newArr;
  connect ( newAcct, SIGNAL( changedParent() ), SLOT( resort() ) );
  resort();
  emit addedAccount( newAcct );
}

void QHaccAccountManager::remove( Account * a ){
  int fillMe=0;
  // we assume the account is in the array. If it's not, big trouble ensues
  // might want to check this
  Account ** newArr=new Account * [ numAccounts-1 ];
  for ( int i=0; i< numAccounts; i++ ){
    if ( accounts[i]!=a ) newArr[fillMe++]=accounts[i];
  }

  numAccounts--;
  delete [] accounts;
  accounts=newArr;
  emit removedAccount ( a );
  delete a;
}

void QHaccAccountManager::resort(){
  // bubblesort, but we don't expect too many accounts
  // also, make sure child accounts are sorted immediately
  // following their parent account

  for ( int i=0; i<numAccounts; i++ ){
    for ( int j=0; j<numAccounts; j++ ){
      if ( accounts[i]->getName( Account::FULL )
	   < accounts[j]->getName( Account::FULL ) ){
	Account * temp=accounts[i];
	accounts[i]=accounts[j];
	accounts[j]=temp;
      }
    }
  }
}

Account * QHaccAccountManager::getByID( unsigned int id ) const{
  for ( int i=0; i<count(); i++ ) 
    if ( accounts[i]->getID()==id ) return accounts[i];
  return 0;
}
Account * QHaccAccountManager::get( int i ) const{
  if ( i<0 || i>=numAccounts ) return 0;
  else return accounts[i];
}

Account * QHaccAccountManager::get( QString name ) const{  
  for ( int i=0; i<numAccounts; i++ )
    if ( accounts[i]->getName()==name ) return accounts[i];
  return 0;
}
Account * QHaccAccountManager::getByFullName( QString name ) const{
  for ( int i=0; i<numAccounts; i++ )
    if ( accounts[i]->getName( Account::FULL )==name ) return accounts[i];
  return 0;
}

int QHaccAccountManager::index( const Account * a ) const{
  for ( int i=0; i<numAccounts; i++ ) if ( accounts[i]==a ) return i;
  return -1;
}

QList <Account> QHaccAccountManager::getAccounts( AccountType type ) const {
  QList <Account> list;
  list.setAutoDelete( false );
  for ( int i=0; i<numAccounts; i++ ) 
    if ( accounts[i]->isType( type ) ) list.append( accounts[i] );
  return list;
}
