/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCACCTCHOOSER_H
#define _QHACCACCTCHOOSER_H

#include <qcolor.h>
#include <qframe.h>
#include <qwidget.h>
#include <qfontmetrics.h>


class Prefs;
class Account;
class Transaction;
class QHaccAccountManager;

class QPainter;
class QKeyEvent;
class QScrollBar;
class QPopupMenu;
class QFocusEvent;
class QMouseEvent;
class QResizeEvent;

class QHaccAccountChooser : public QFrame{
  Q_OBJECT
    public:
  QHaccAccountChooser( QWidget * =0, const char * =0 );
  ~QHaccAccountChooser();
  void setIndex( int );
  int getIndex() const;
  
 protected:
  void drawContents( QPainter * );
  void keyReleaseEvent( QKeyEvent * );
  void focusInEvent ( QFocusEvent * );
  void focusOutEvent ( QFocusEvent * );
  void mouseMoveEvent( QMouseEvent * );
  void mousePressEvent( QMouseEvent * );
  void mouseReleaseEvent( QMouseEvent * );
  void mouseDoubleClickEvent( QMouseEvent * );
  
 private:
  QHaccAccountManager * manager;
  QScrollBar * scroller;
  int line, numViewableLines, active, remChoice;
  QPopupMenu * popup;
  const Prefs * prefs;

  public slots:
    void recalcSizes();
  void resizeEvent ( QResizeEvent * );
  void reconcile();
  void vrepaint();
  void editAcct();
  void newAcct();
  void remAcct();
  void report();
  void chart();

 signals:
  void changedAccount( Account * );
};

#endif


