/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

#ifndef _PREFS_H
#define _PREFS_H

#include "globals.h"

#include <qfont.h>
#include <qcolor.h>
#include <qobject.h>
#include <qdatetime.h>
#include <qstrlist.h>
#include <qfontmetrics.h>

class Prefs : public QObject{
  Q_OBJECT
 private:
  Prefs();

 public:
  static Prefs * getInstance();

  int getLines() const;
  QFont getFont() const;
  QColor getMainColor() const;
  QColor getAltColor() const;
  QString getSymbol() const;
  DateFormat getDateFormat() const;
  QString getDateSeparator() const;
  QString getDateString( QDate ) const;
  QStrList getTransTypes() const;
  static QDate getDateFromString( const QString& );

  Decoration getDecoration() const;
  GraphType getGraphType() const;
  void setDecoration( Decoration );
  void setGraphType( GraphType );
  void setTransTypes( QStrList );

  void setLines( int );
  void setMainColor( QColor );
  void setAltColor( QColor );
  void setSymbol( QString );
  void setFont( QFont );
  void toggleLines();
  void setDateFormat( DateFormat );
  void setDateSeparator( QString );

 private:
  int lines;
  QColor mainColor, altColor;
  QFont font;
  DateFormat dateFormat;
  QString separator, symbol;
  Decoration decs;
  GraphType gtype;
  QStrList transTypes;
  static Prefs * instance;

  public slots:
    void resetPrefs();

 signals:
  void changedAltColor( QColor );
  void changedMainColor( QColor );
  void changedSymbol( QString );
  void changedLines( int );
  void changedFont( QFont );
  void changedDateFormat( DateFormat );
  void changedDecoration( Decoration );
};

#endif
