/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * ***************************/

#include "qhacc.h"
#include "config.h"

#include <stdlib.h>
#include <iostream.h>

void showWarranty(){ 
  cout<<"                           NO WARRANTY"<<endl;

  cout<<"   BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY"<<endl;
  cout<<"FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN"<<endl;
  cout<<"OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES"<<endl;
  cout<<"PROVIDE THE PROGRAM \"AS IS\" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED"<<endl;
  cout<<"OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF"<<endl;
  cout<<"MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS"<<endl;
  cout<<"TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE"<<endl;
  cout<<"PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,"<<endl;
  cout<<"REPAIR OR CORRECTION."<<endl;

  cout<<"    IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING"<<endl;
  cout<<"WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR"<<endl;
  cout<<"REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,"<<endl;
  cout<<"INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING"<<endl;
  cout<<"OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED"<<endl;
  cout<<"TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY"<<endl;
  cout<<"YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER"<<endl;
  cout<<"PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE"<<endl;
  cout<<"POSSIBILITY OF SUCH DAMAGES."<<endl<<endl;
  exit( 0 );
}

void showIntro( const char * progname ){
  cout<<"QHacc version "<<VERSION;
  cout<<", Copyright (C) 2000 Ryan Bobko <ryan@ostrich-emulators.cx>"<<endl
      <<"QHacc comes with ABSOLUTELY NO WARRANTY; for details type `"
      <<progname<<" -w'."<<endl
      <<"This is free software, and you are welcome to redistribute it"<<endl
      <<"under certain conditions; Please see the GNU Public License "
      <<"for details."<<endl;
}

void helpQuit( const char * progname ){
  cout<<"usage: "<<progname<<endl;
  cout<<" [-f          <QHACC_HOME>]"<<endl
      <<" [-w]         show warranty information"<<endl
      <<" [--cron      <Transaction File>]"<<endl
      <<" [--archive   <Date String>]"<<endl
      <<" [--restore   <Archive Directory>]"<<endl
#ifdef QGRAPHS
      <<" [--report    <Account or Account Type>]"<<endl
#endif
      <<" [--balances] list accounts, and balances"<<endl
      <<" [--help]     show this screen"<<endl<<endl;
  cout<<" if the -f option is given, it must be the first argument"<<endl;
  exit ( 0 );
}

int main( int argc, char **argv ){
  char * env=getenv( "QHACC_HOME" );
  bool interactive=true;
  //for ( int i=0; i<argc; i++ ) cout<<i<<": "<<argv[i]<<endl;

  for ( int i=1; i<argc; i++ ){
    if ( strcmp( argv[i], "-f" )==0 ){
      i++;
      if ( i<argc ) env=argv[i];
      else helpQuit( argv[0] );
    }
    
    else if ( strcmp( argv[i], "--cron" )==0 ){
      i++;
      if ( i<argc ) {
	QHacc::unmanned( QHacc::CRON, env, argv[i] );
	interactive=false;
      }
      else helpQuit( argv[0] );
    }
    else if ( strcmp( argv[i], "--archive" )==0 ){
      i++;
      if ( i<argc ){
	QHacc::unmanned( QHacc::ARCHIVE, env, argv[i] );
	interactive=false;
      }
      else helpQuit( argv[0] );
    }    
    else if ( strcmp( argv[i], "--restore" )==0 ){
      i++;
      if ( i<argc ){
	QHacc::unmanned( QHacc::RESTORE, env, argv[i] );
	interactive=false;
      }
      else helpQuit( argv[0] );
    }    
    else if ( strcmp( argv[i], "--report" )==0 ){
      i++;
      if ( i<argc ){
	QHacc::unmanned( QHacc::REPORT, env, argv[i] );
	interactive=false;
      }
      else helpQuit( argv[0] );      
    }

    else if ( strcmp( argv[i], "--balances" )==0 ){
      QHacc::unmanned( QHacc::BALANCES, env );
      interactive=false;
    }
    else if ( strcmp( argv[1], "-w" )==0 ) showWarranty();
    else helpQuit( argv[0] );
  }

  if ( interactive ){
    showIntro( argv[0] );
    QApplication::setColorSpec( QApplication::CustomColor );
    QApplication a( argc, argv );
    QHacc q( env );
    a.setMainWidget( &q );
    q.show();
    return a.exec();
  }
}



