#! /bin/sh
##################################################
## This script will convert the transaction save #
## files from version 0.2.1 to version 0.2.5     #
##################################################

ACCTS=$(grep "ACCTFILES=" config|cut -d'=' -f2-)
TMP=/tmp/tmper
typeset -i highcount=0

# all the account types changed in the latest release
# we'll have to go through and try to mimic the new
# format before trying to load the accounts

for f in ${ACCTS}; do
    typeset file=${f}.info
    typeset -i type=$(grep "TYPE=" ${file}|cut -d'=' -f2)
    
    case ${type} in
    0)
      echo "DEFAULTTRANSTYPE=<incr number>" >> ${file}
    ;;
    1)
      echo "DEFAULTTRANSTYPE=DEP" >> ${file}
      grep -v "TYPE" ${file} > ${TMP}
      echo "TYPE=0" >> ${TMP}
      mv ${TMP} ${file}
    ;;
    2)
      grep -v "TYPE" ${file} > ${TMP}
      echo "TYPE=1" >> ${TMP}
      mv ${TMP} ${file}
    ;;  
    3)
    ;;
    4)
    ;;
    5)
      grep -v "TYPE" ${file} > ${TMP}
      echo "TYPE=3" >> ${TMP}
      mv ${TMP} ${file}
    ;;
    esac
done

rm -f ${TMP}