#!/bin/sh
################################################################
# This script will create bogus datafiles for version 0.2.5
# it is useful for stress-testing QHacc
################################################################
typeset -i count=0 maxcount=50 maxtrans=1000 transcount=1
typeset PAIRED="NO" ACCTS=

if [ x"$1" != "x" ]; then
  maxcount=$1
fi

if [ x"$2" != "x" ]; then
  maxtrans=$2
fi

if [ x"$3" == "xp" ]; then
  PAIRED="YES"
fi

echo "ALTCOLOR=255 170 127" > config
echo "LINESPERTRANS=2" >> config
echo "NUMSHOWS=$maxcount" >> config
echo "NUMACCTS=$maxcount" >> config
echo "SHOWINDEX=0" >> config
echo -n "ACCTFILES=" >> config

while [ $count -lt $maxcount ];do
  typeset file="acct$count.info"
  ACCTS[$count]="acct$count.trans"
  echo -n "acct$count " >> config
  rm -rf $file ${ACCTS[$count]}

  echo "TYPE=0" >> $file
  echo "NAME=Account #$count" >> $file
  echo "INSTITUTION=" >> $file
  echo "INSTADDR1=" >> $file
  echo "INSTADDR2=" >> $file
  echo "INSTCITY=" >> $file
  echo "INSTSTATE=" >> $file
  echo "INSTZIP=" >> $file
  echo "INSTPHONE=" >> $file
  echo "INSTFAX=" >> $file
  echo "INSTEMAIL=" >> $file
  echo "ID=" >> $file
  echo "TAXABLE=Y" >> $file
  echo "INCOME=Y" >> $file
  echo "BAL=100" >> $file
  count=$count+1
  echo "ACCTID="$count >> $file
done

count=0
while [ $count -lt $maxcount ];do
  typeset -i nt=$RANDOM count2=0 paircount=0
  let nt=$nt%$maxtrans
  typeset t1=${ACCTS[$count]}

  while [ $count2 -lt $nt ]; do
    typeset -i mon=$RANDOM
    let mon=$mon%11+1
    typeset -i day=$RANDOM
    let day=$day%29+1
    typeset -i year=$RANDOM
    let year=$year%29
    let year=$year+70
    typeset -i amt=$RANDOM cents=$RANDOM
    let amt=$amt%500
    let cents=$cents%100
    typeset -i recT=$RANDOM
    let recT=$recT%2
    typeset reco

    if [ $recT -eq 0 ]; then
      reco="N"
    else
      reco="Y"
    fi
    if [ $mon -eq 2 -a $day -eq 29 ]; then
      day=28
    fi
    
    if [ x"$PAIRED" == "xYES" ]; then
      typeset -i otherAcct
      let otherAcct=$RANDOM%$maxcount
      typeset t2=${ACCTS[$otherAcct]}
      otherAcct=$otherAcct+1
      paircount=$transcount+1
      # need to add an account id into this line
      typeset -i cc
      cc=$count+1
      echo -n "$paircount||1||$transcount||$cc||$count2||payee " >> $t2
      echo "#$count2||memo||$amt.$cents||$reco||$mon/$day/19$year" >> $t2

      echo -n "$transcount||1||$paircount||$otherAcct||$count2||" >> $t1
      echo "payee #$count2||memo||$amt.$cents||$reco||$mon/$day/19$year" >> $t1

    else
      echo -n "$transcount||0||$count2||payee #$count2||" >> $t1
      echo "memo||$amt.$cents||$reco||$mon/$day/19$year" >> $t1
    fi

    count2=$count2+1
    transcount=$transcount+1
  done
  echo "$count2 transactions added to Account #$count"
  count=$count+1
done

count=0
while [ $count -lt $maxcount ];do
  typeset tf=${ACCTS[$count]]}
  echo "NUMTRANS="$(wc -l $tf|awk '{print $1}') > /tmp/scrap
  cat /tmp/scrap $tf > /tmp/s2
  mv /tmp/s2 $tf
  rm -rf /tmp/scrap
  count=$count+1
done

transcount=$transcount-1
if [ x"$PAIRED" == "xYES" ]; then
  let transcount=$transcount*2
fi

echo $transcount" transactions in $maxcount accounts"
echo >> config

