/***************************************************************************
                          rprgdef.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

// Program defines:
//

#ifndef RPRGDEF_H
#define RPRGDEF_H

#include <qwindowdefs.h>
  
// Debug level
//
//#define DEF_RDEBUG          // Debug Messages to debug file
//#define DEF_RDEBUGMENU      // Debug Menu on
//#define DEF_RDEBUGTIME      // Debug Times to debug file
//#define DEF_LESS_DIALOGS    // Don't show the startup dialog


// Uncomment for Linux
#define DEF_LINUX           // Are we running Linux?
#define RUNNING_LINUX   true
#define RUNNING_WINDOWS false
#define RUNNING_SOLARIS false
#define RUNNING_IRIX    false
#define DATADIR         "/usr/share"


#ifdef __FreeBSD__
#define DEF_FREEBSD
#undef DEF_LINUX
#define RUNNING_LINUX   true    // close enough
#define RUNNING_WINDOWS false
#define RUNNING_SOLARIS false
#define RUNNING_IRIX    false
#endif


// Uncomment for Solaris
/*
#define DEF_SOLARIS           // Are we running Solaris?
#define RUNNING_SOLARIS true
#define RUNNING_WINDOWS false
#define RUNNING_LINUX   false
#define RUNNING_IRIX    false
*/


// Uncomment for Windoze
/*
#define DEF_WINDOWS           // Iiiik - we're running windoze!!!
#define RUNNING_WINDOWS true
#define RUNNING_LINUX   false
#define RUNNING_SOLARIS false
#define RUNNING_IRIX    false
*/



// Uncomment for IRIX
/*
#define DEF_SGI               // Are we running IRIX?
#define RUNNING_SOLARIS false
#define RUNNING_WINDOWS false
#define RUNNING_LINUX   false
#define RUNNING_IRIX    true
*/


#ifdef DEF_SOLARIS
#define true 1
#define false 0
#endif

#define DEF_QCAD                       // Compile QCad
////#define DEF_CAM_EXPERT               // Compile CAM Expert
#define DEF_INCH_MODE      false       // Compile American version with inches as default
#define DEF_LANGUAGE       "en"        // Default language

// QCad specific defines:
//
#ifdef DEF_QCAD
#define   DEF_APPNAME      "QCad"
#define   DEF_APPNAME_L    "qcad"
#define   DEF_APP_ICON     qcad_xpm
#define   DEF_ORG_ICON     ribbonsoft_xpm
#define   DEF_INTRO        qcadintro_xpm
#define   DEF_INTRO_VERX   230
#define   DEF_INTRO_VERY   182
#define   DEF_VERSION      "1.5.4"
#define   DEF_FIRM         "RibbonSoft"
#define   DEF_SUPPORTEMAIL "andrew@qcad.org"
#define   DEF_INTERNET     "http://www.qcad.org"
#define   DEF_RECENTPOS    14                // The index, where recent files get inserted
#endif                                       //   = first index after "Quit" and the Seperator



#ifdef DEF_CAM_EXPERT
#define   DEF_APPNAME      "CAM Expert"
#define   DEF_APPNAME_L    "camexp"
#define   DEF_APP_ICON     camexp_xpm
#define   DEF_ORG_ICON     ribbonsoft_xpm
#define   DEF_INTRO        camexpintro_xpm
#define   DEF_INTRO_VERX   230
#define   DEF_INTRO_VERY   182
#define   DEF_VERSION      "2.5.4"
#define   DEF_FIRM         "RibbonSoft"
#define   DEF_SUPPORTEMAIL "info@ribbonsoft.com"
#define   DEF_INTERNET     "http://www.ribbonsoft.com"
#define   DEF_RECENTPOS    14                // The index, where recent files get inserted
#endif                                       //   = first index after "Quit" and the Seperator



// General defines:
//
#define DEF_RELEASE      "2002-09-20"
#define DEF_PROGRAMMER   "Andrew Mustun"

#define DEF_MAXDOCUMENTS 128    // Max number of documents that can be loaded
#define DEF_RECENTFILES  8      // Number of recent files in "File"-Menu
#define DEF_MENUBUF      8      // Menu Buffer
                                //   (right mouse click can go back ... menus)

#define DEF_TRIALPERIOD  60     // Trial period for demos

// Windows specific settings:
//
#ifndef DEF_LINUX
#define   DEF_DEBUGFILE    "debug.txt"
#else

// Linux specific settings:
//
#define   DEF_DEBUGFILE    "./debug.txt"
#endif

#endif

// EOF

