/***************************************************************************
                          rparameterdialog.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** RParameterDialog.cpp 1998/09/03 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/


#include <string.h>

#include <qapplication.h>
#include <qkeycode.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qstring.h>
#include <qpushbutton.h>

#include "rparameterdialog.h"
#include "rlineedit.h"
#include "rlog.h"
#include "rmath.h"
#include "rprgdef.h"
#include "rstring.h"

#define DEF_MAXENTRIES 6

// Constructor:
//
RParameterDialog::RParameterDialog(QWidget* _parent, 
                                   const QString& _title, 
                                   QPixmap& _pixmap)
  :QDialog(_parent, _title, true, WStyle_NormalBorder)
{
  setCaption(_title);

  setFixedSize(DEF_PARAMDLG_WIDTH, DEF_PARAMDLG_HEIGHT);
  
  gl = new QGridLayout(this, DEF_MAXENTRIES+2, 4, 8, 0);
  for(int i=0; i<DEF_MAXENTRIES+2; ++i) {
    gl->setRowStretch(i, 1);
  }
  
  gl->setColStretch(0, 17);
  gl->setColStretch(1, 8);
  gl->setColStretch(2, 8);
  gl->setColStretch(3, 8);
  
  
  QLabel* pixmap = new QLabel(this);
  pixmap->setPixmap(_pixmap);
  gl->addMultiCellWidget(pixmap, 0, DEF_MAXENTRIES+1, 0, 0);

  bOk = new QPushButton(tr("Ok"), this);
  bOk->setAccel(Key_Return);
  gl->addWidget(bOk, DEF_MAXENTRIES+1, 2);
  connect(bOk, SIGNAL(clicked()), SLOT(accept()));
  
  bCancel = new QPushButton(tr("Cancel"), this);
  bCancel->setAccel(Key_Escape);
  gl->addWidget(bCancel, DEF_MAXENTRIES+1, 3);
  connect(bCancel, SIGNAL(clicked()), SLOT(reject()));

  /*
  bHelp = new QPushButton(tr("Help"), this);
  bHelp->setAccel(Key_F1);
  gl->addWidget(bHelp, DEF_MAXENTRIES+1, 3);
  */
  
  lLabel.setAutoDelete(true);
  eInput.setAutoDelete(true);
  
  insertPos=0;

}



// Destructor:
//
RParameterDialog::~RParameterDialog()
{

}



// Add an input with a char* as default value:
//
void 
RParameterDialog::addEntry(const QString& _mes, const QString& _val)
{
  QLabel* label = new QLabel(_mes, this);
  label->setAlignment(AlignRight|AlignVCenter);
  gl->addMultiCellWidget(label, insertPos+1, insertPos+1, 1, 2);
  lLabel.append(label);

  RLineEdit* input = new RLineEdit(this);
  input->setText(_val);
  gl->addWidget(input, insertPos+1, 3);
  eInput.append(input);
  if(insertPos<DEF_MAXENTRIES) ++insertPos;
}



// Add an input with an int as default value:
//
void 
RParameterDialog::addEntry(const QString& _mes, int _val)
{
  char val[256];
  sprintf(val, "%d", _val);
  addEntry(_mes, val);
}



// Add an input with a double as default value:
//
void 
RParameterDialog::addEntry(const QString& _mes, double _val)
{
  char val[256];
  strncpy(val, strFloatToString(_val).latin1(), 255);
  addEntry(_mes, val);
}



// Get the input in field _index as a string:
//
QString
RParameterDialog::getStringInput(int _index)
{
  if(_index>=0 && _index<(int)eInput.count()) {
  
    RLOG("\nStringInput at ");
    RLOG(_index);
    RLOG(" is ");
    RLOG(eInput.at(_index)->text());
    
    return eInput.at(_index)->text();
  }
  else {
    return 0;
  }
}



// Get the input in field _index as an int:
//
int
RParameterDialog::getIntInput(int _index)
{
  QString val=getStringInput(_index);
  return mtRound( mtCalculate( val ) );
}



// Get the input in field _index as a double:
//
double
RParameterDialog::getFloatInput(int _index)
{
  QString val=getStringInput(_index);
  return mtCalculate( val );
}



// EOF3


