/***************************************************************************
                          rfiledgn.cpp  -  description
                             -------------------
    begin                : Wed Dec 22 1999
    copyright            : (C) 1999 by Jan Van Sweevelt
    email                : jan-vansweevelt@freegates.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rfiledgn.h"

#include <stdlib.h>

#include <qstring.h>
#include <qdatetime.h>

#include "rappwin.h"
#include "rfonts.h"
#include "rgraphic.h"
#include "rlog.h"
#include "rmath.h"
#include "rprgdef.h"
#include "rstatuspanel.h"


RFileDgn::RFileDgn(const QString& _name, RGraphic* _graphic):QFile(_name){

strcpy(DGNfilename, _name);
graphic = _graphic;

}

RFileDgn::~RFileDgn(){
}

bool RFileDgn::load()
{
int bt,i,offset;
char buffer[DGNELM_HDR_SIZE];
DGNElm_hdr filehead;
DGNDisp_hdr elemattr;
char layer[5];
DGNLine_2d line;
DGNLine_String_2d linestring;
Point2d vertex;
int X1,Y1,X2,Y2;

if(Open())
{

  /* Create 63 layers because microstation has 63 and only 63 layers */
  for(i=1;i<=63;i++)
  {
  	sprintf(layer,"%d",i);
    graphic->addLayer(layer);
  }

  do
  {
    bt = readBlock(buffer, DGNELM_HDR_SIZE);
  	filehead = *((DGNElm_hdr *) buffer);
  	offset = at();
  	if(filehead.deleted == 0)
  	{
  		switch(filehead.type)
  		{
  	  	case LINE_DGNELM:        elemattr = ReadAttributes();
  	  	                         graphic->setColor(elemattr.s.color);
  	                             graphic->setWidth(elemattr.s.weight);
  	                             graphic->setStyle(graphic->numberToStyle(elemattr.s.style));
  	                             bt = readBlock(buffer, sizeof(DGNLine_2d));
  	                             line = *((DGNLine_2d *) buffer);
  	                             SWITCHINT(X1, line.start.x);
  	                             SWITCHINT(Y1, line.start.y);
  	                             SWITCHINT(X2, line.end.x);
  	                             SWITCHINT(Y2, line.end.y);
  	                             graphic->addLine(X1, Y1, X2, Y2, filehead.level, false);
  	                             at(offset + ((filehead.words+2)*2)-DGNELM_HDR_SIZE);	
  	                             break;
  	
  	    case LINE_STRING_DGNELM: elemattr = ReadAttributes();
  	  	                         graphic->setColor(elemattr.s.color);
  	                             graphic->setWidth(elemattr.s.weight);
  	                             graphic->setStyle(graphic->numberToStyle(elemattr.s.style));
  	                             bt = readBlock(buffer, sizeof(DGNLine_String_2d));
  	                             linestring = *((DGNLine_String_2d *) buffer);
  	                             bt = readBlock(buffer, sizeof(Point2d));
  	                             vertex = *((Point2d *) buffer);
  	                             SWITCHINT(X1, vertex.x);
  	                             SWITCHINT(Y1, vertex.y);
  	                             for(i=1;i<linestring.numverts;i++)
  	                             {
  	                               bt = readBlock(buffer, sizeof(Point2d));
  	                               vertex = *((Point2d *) buffer);
  	                               SWITCHINT(X2, vertex.x);
  	                               SWITCHINT(Y2, vertex.y);
  	                             	 graphic->addLine(X1, Y1, X2, Y2, filehead.level, false);
  	                             	 X1 = X2;
  	                             	 Y1 = Y2;
  	                             }
  	                             at(offset + ((filehead.words+2)*2)-DGNELM_HDR_SIZE);	
  	                             break;
  	
  		  default: at(offset + ((filehead.words+2)*2)-DGNELM_HDR_SIZE);
  		           break;
  	  }
  	} else
  		at(offset + ((filehead.words+2)*2)-DGNELM_HDR_SIZE);
  }while(at() < (int)size());

  graphic->terminateAction();

	return true;
}
return false;	
}

bool RFileDgn::Open()
{
int bt;
char buffer[DGNELM_HDR_SIZE];
DGNElm_hdr filehead;

if(open(IO_ReadOnly))
{
  bt = readBlock(buffer, DGNELM_HDR_SIZE);
  filehead = *((DGNElm_hdr *) buffer);
  if(filehead.type == DGNFIL_HEADER_DGNELM)
  {
  /* Move file pointer */
    at(at() + ((filehead.words+2)*2)-DGNELM_HDR_SIZE);
		return true;
  }
}
return false;
}

DGNDisp_hdr RFileDgn::ReadAttributes()
{
int bt;
char buffer[DGNELM_HDR_SIZE];
DGNDisp_hdr elemattr;

bt = readBlock(buffer, DGNELM_PRP_SIZE);
elemattr = *((DGNDisp_hdr*) buffer);
//return *((DGNDisp_hdr*) buffer);
return elemattr;
}










