/***************************************************************************
                          rdimdlg.cpp  -  description
                             -------------------
    begin                : Tue Feb 15 2000
    copyright            : (C) 2000 by Gerald Pichler
    email                : geripi@sbox.tu-graz.ac.at
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "rdimdlg.h"

/* Diameter sign */
static const char * diamsign_xpm[] = {
"9 9 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"        .",
"   ... . ",
"  .   .  ",
" .   . . ",
" .  .  . ",
" . .   . ",
"  .   .  ",
" . ...   ",
".        "};

RDimDlg::RDimDlg(QWidget *_parent, const char *_name)
 : QFrame(_parent, _name)
{
  this->resize(150,50);
  this->setMinimumSize(0,0);
  QLabel_2= new QLabel(this,"NoName");
  QLabel_2->setGeometry(6,20,9,9);
  QLabel_2->setMinimumSize(0,0);
  QLabel_2->setPixmap(QPixmap(diamsign_xpm));

  QCheckBox_diam= new QCheckBox(this,"diam");
  QCheckBox_diam->setGeometry(20,15,20,20);
  QCheckBox_diam->setMinimumSize(0,0);
  QCheckBox_diam->setText("");

  RLineEdit_main= new RLineEdit(this,"main");
  RLineEdit_main->setGeometry(35,15,60,20);
  RLineEdit_main->setMinimumSize(0,0);
  RLineEdit_main->setText("");
  RLineEdit_main->selectAll();

  RLineEdit_upTol= new RLineEdit(this,"upTol");
  RLineEdit_upTol->setGeometry(95,5,50,20);
  RLineEdit_upTol->setMinimumSize(0,0);
  RLineEdit_upTol->setFocus();
  RLineEdit_upTol->setText("");
  RLineEdit_upTol->selectAll();

  RLineEdit_lowTol= new RLineEdit(this,"lowTol");
  RLineEdit_lowTol->setGeometry(95,25,50,20);
  RLineEdit_lowTol->setMinimumSize(0,0);
  RLineEdit_lowTol->setText("");
  RLineEdit_lowTol->selectAll();

  setFrameStyle(Panel|Raised);
  setLineWidth(1);

  connect(QCheckBox_diam, SIGNAL(clicked()), this, SLOT(Changed()));
  connect(RLineEdit_main, SIGNAL(textChanged(const QString&)),
  			  this, SLOT(Changed()));
  connect(RLineEdit_upTol, SIGNAL(textChanged(const QString&)),
  			  this, SLOT(Changed()));
  connect(RLineEdit_lowTol, SIGNAL(textChanged(const QString&)),
  			  this, SLOT(Changed()));

  element = 0;
}

RDimDlg::~RDimDlg(){
}


void
RDimDlg::reset() {
	setDiam(false);
	setMain("");
	setLowTol("");
	setUpTol("");
}


void
RDimDlg::Changed() {
	if(element){
	  QString diam;
	  if(QCheckBox_diam->isChecked()) diam=""; else diam="";
	  QString m=RLineEdit_main->text();
	  QString u=RLineEdit_upTol->text();
	  QString l=RLineEdit_lowTol->text();
	
	  diam+=m+=";"; diam+=u+=";"; diam+=l;
	
  	element->setText(diam);
  }
}
