/***************************************************************************
                          rcadwidget.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rcadwidget.cpp 1998/08/24 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <qapplication.h>
#include <qprinter.h>
#include <qpaintdevicemetrics.h>

#include "rcadwidget.h"

#include "rappwin.h"
#include "rcolor.h"
#include "rgraphic.h"
#include "rlayoutdef.h"
#include "rlog.h"

// Constructor:
//
// _rw: read/write?
//
RCadWidget::RCadWidget(bool _rw,
                       RAppWin* _appWin,
                       QWidget* _parent, 
                       const char* _name, 
                       WFlags _f)
:RWidget(_parent, _name, _f)
{
  graphic=0;
  setBackgroundColor(rDarkGray);
  //setEraseColor(darkGray);
  //setEraseColor(rDarkGray);
  layerWidget=new RLayerWidget(_rw, this, "rlayerwidget");
  layerWidget->hide();
  libraryBrowser=0;
  if(_rw) {
    libraryBrowser = new RLibraryBrowser( this, "libraryBrowser" );
    libraryBrowser->hide();
  }
  infoWidget=new RInfoWidget(this, "rinfowidget");
  infoWidget->hide();
  printPreview=false;
  appWin = _appWin;
  show();
}



// Destructor:
//
RCadWidget::~RCadWidget()
{
}


// Get file name (from graphic):
//
QString
RCadWidget::getFileName() 
{ 
  if(graphic) {
    return graphic->getFileName(); 
  }
  else {
    return QString();
  }
}



// Set pointer to graphic:
//   connect graphic with layer list
//
void
RCadWidget::setGraphic(RGraphic* _graphic)
{
  bool reactivate=false;   // reactivate this graphic for simulation events
  
  RLOG("setGraphic");
  
  if(layerWidget && graphic) {
    // Disconnect old signals:
    //
    disconnect(graphic);
    disconnect(layerWidget,0, graphic,0);

    RLOG("\ndisconnected graphic");

    if(graphic && graphic->isActive()) {
      reactivate=true;
      graphic->setActive(false);
    }
  }

  // Set new Graphic pointer:
  //  
  graphic=_graphic;

  if(layerWidget) {
    layerWidget->setGraphic(graphic);
    if(graphic) {
      // Connect signal "updateLayers" from the current
      //   graphic document with slot "updateLayerList"
      //   from the layerWidget
      //
      connect(graphic,  SIGNAL(updateLayers()), 
              layerWidget, SLOT(updateLayerList()));
  
      // Connect signal "layerSwitched" from the LayerWidget
      //   with slot "switchLayer" from the current graphic 
      //   document:
      //
      connect(layerWidget, SIGNAL(layerSwitched(const QString&)), 
              graphic,  SLOT(switchLayer(const QString&)));

      // Connect signal "layerSelected" from the LayerWidget
      //   with slot "selectLayer" from the current graphic 
      //   document:
      //
      connect(layerWidget, SIGNAL(layerSelected(const QString&)), 
              graphic,  SLOT(selectLayer(const QString&)));

      if(reactivate) RAppWin::getRAppWin()->activateDocument(graphic);
    }
  }

  if(infoWidget) {
    infoWidget->setGraphic(graphic);

    if(graphic) {
      // Connect signal "graphicChanged" from the current
      //   graphic document with slot "updateInfo"
      //   from the infoWidget
      //
      connect(graphic,  SIGNAL(graphicChanged()), 
              infoWidget, SLOT(updateInfo()));
    }
  }
}



// Show cad widget and all widgets in it:
//
void 
RCadWidget::show()
{
  RWidget::show();
  
  if(graphic) {
    graphic->show();
  }
}



// Resize event:
//
void 
RCadWidget::resizeEvent(QResizeEvent* /*_ev*/ )
{
  //RWidget::resizeEvent(_ev);
  
  resizeChildren();
}



// Resize children:
//
void 
RCadWidget::resizeChildren()
{
  // Resize cad graphic:
  //
  //if(graphic) {

    int rightBorder=width();    // Borders of graphic widget
    int bottomBorder=height();
    bool lbVisible=false;       // Library browser visible
    bool lyVisible=false;       // Layer widget visible

    if(libraryBrowser && isLibraryBrowserVisible()) lbVisible=true;
    if(layerWidget && isLayerWidgetVisible()) lyVisible=true;
    
    if(graphic) graphic->setUpdatesEnabled(false);
  
    if(infoWidget && isInfoWidgetVisible()) {
      bottomBorder=height()-DEF_INFOHEIGHT;
      infoWidget->setGeometry(0, bottomBorder,
                              width(), DEF_INFOHEIGHT);
    }
    
    if(lyVisible) {
      //QSize wdgSize=layerWidget->sizeHint();
      //rightBorder=width()-wdgSize.width();
      rightBorder=width()-DEF_MINLAYERLISTWIDTH;
      layerWidget->setGeometry(rightBorder, 0, 
                               DEF_MINLAYERLISTWIDTH, (lbVisible ? bottomBorder/3 : bottomBorder));
    }

    if(lbVisible) {
      rightBorder=width()-DEF_MINLAYERLISTWIDTH;
      libraryBrowser->setGeometry(rightBorder, (lyVisible ? bottomBorder/3 : 0),
                                  DEF_MINLAYERLISTWIDTH, (lyVisible ? bottomBorder/3*2 : bottomBorder));
    }
    
    // Print preview (resize to the paper size):
    //
    if(printPreview && appWin) {
    
      /*graphic->setGeometry(50,0, 
                           rightBorder-50, 
                           bottomBorder);*/
                           
      //appWin->updatePrintMetrics();
      
      if(appWin->getPaperHeight()>0 && appWin->getPaperWidth()>0) {
        double z;
        int w = appWin->getPaperWidth();
        int h = appWin->getPaperHeight();
        
        if((double)bottomBorder/h < (double)rightBorder/w) {
          z=(double)bottomBorder/h;
        }
        else {
          z=(double)rightBorder/w;
        }
        
        if(graphic) graphic->setGeometry((int)((rightBorder-z*w)/2),
                                         (int)((bottomBorder-z*h)/2), 
                                         (int)(rightBorder-(rightBorder-z*w)), 
                                         (int)(bottomBorder-(bottomBorder-z*h)));
      }
      else {
        if(graphic) graphic->setGeometry(50,0, 
                                         rightBorder-100, 
                                         bottomBorder);
      }
    }
    
    // Normal mode:
    //
    else {
      if(graphic) graphic->setGeometry(0,0, 
                                       rightBorder, 
                                       bottomBorder);
    }
                         
    if(graphic) {
      graphic->setUpdatesEnabled(true);
      graphic->update();
    }
  //}
}


// EOF


