#! /usr/bin/env python

# setup.py --- Setup script for PyXMMS
# Copyright (c) 2002 Florent Rougon
#
# This file is part of PyXMMS.
#
# PyXMMS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# PyXMMS is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; see the file COPYING. If not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
# MA 02111-1307, USA.

import os, string, sys
from distutils.core import setup, Extension

# Notes:
#  1) The Distutils included in Python 2.1 don't understand the "license"
#     keyword argument of setup correctly (they only understand licence); as I
#     don't want to mispell it, if you run the Distutils from Python 2.1, you
#     will get License: UNKNOWN. This problem does not appear with the version
#     included in Python 2.2.
#  2) I would like to use the keyword argument "extra_compile_args" of setup to
#     pass the output of glib-config --cflags to Distutils but it goes to the
#     end of the gcc command, which is useless in this case. So, I use
#     "include_dirs" instead.

PACKAGE = "pyxmms"
VERSION = "1.06"
GLIB_CONFIG = "glib-config"

def main():
    glib_opts = {}
    for op in ("cflags", "libs"):
        glib_config_pipe = os.popen("%s --%s" % (GLIB_CONFIG, op), 'r')
        # strip the trailing newline
        glib_opts[op] = glib_config_pipe.read()[:-1]
        if glib_config_pipe.close() != None:
            sys.exit("%s returned a non-zero exit status. Aborting."
                     % GLIB_CONFIG)

    # Suppress the -I in each -Idir output by glib-config --cflags (ugly)
    glib_include_dirs = map(lambda s: s[2:],
                            string.split(glib_opts["cflags"], ' '))

    setup(name=PACKAGE,
          version=VERSION,
          description="A Python interface to XMMS",
          author="Florent Rougon",
          author_email="flo@via.ecp.fr",
          maintainer="Florent Rougon",
          maintainer_email="flo@via.ecp.fr",
          url="http://www.via.ecp.fr/~flo/",
          license="GPL",
          platforms="Unix",
          long_description = """\
A Python interface to XMMS consisting of all the xmms_remote_* functions
from libxmms plus some higher-level functions. This should provide anything
needed to control XMMS from an external program.""",
          keywords=["xmms"],
          py_modules=["xmms"],
          ext_modules=[Extension("_xmms", ["_xmmsmodule.c"],
                                 include_dirs=glib_include_dirs,
                                 libraries=["xmms"],
                                 extra_link_args=[glib_opts["libs"]])])

if __name__ == "__main__": main()
