# For documentation, see comments in Module/LDAPObject.c and the
# ldap.sasl module documentation.

import ldap,ldap.sasl

l = ldap.initialize("ldap://localhost:1390/",trace_level=2)
l.protocol_version = 3  

# Using SASL mech DIGEST-MD5
auth = ldap.sasl.digest_md5("michael","secret")
try:
  l.sasl_bind_s("", auth)
except ldap.LDAPError,e:
  print 'Error using SASL mechanism',auth.mechanism,str(e)
else:
  print 'Sucessfully bound using SASL mechanism',auth.mechanism

# Using SASL mech EXTERNAL
auth = ldap.sasl.external()
try:
  l.sasl_bind_s("", auth)
except ldap.LDAPError,e:
  print 'Error using SASL mechanism',auth.mechanism,str(e)
else:
  print 'Sucessfully bound using SASL mechanism',auth.mechanism

#res = l.search_s("",ldap.SCOPE_BASE,"(objectClass=*)")
#print res

l.unbind()
