# greetingInKorean.py
#
# Demonstration of the parsing module, on the prototypical "Hello, World!" example
#
from pyparsing import Word, srange

koreanChars = srange(r"[\0xac00-\0xd7a3]")
koreanWord = Word(koreanChars,min=2)

# define grammar
greet = koreanWord + "," + koreanWord + "!"

# input string
hello = u'\uc548\ub155, \uc5ec\ub7ec\ubd84!' #"Hello, World!" in Korean

# parse input string
print hello, "->", greet.parseString( hello )
