import unittest, tempfile, shutil, os

run = 1
try:
    from programs.pfreport import *
except ImportError:
    # We probably don't have GDChart installed...
    run = 0
    
if run:
    LOG = "pfreport_data/pflog"
    class uReports(unittest.TestCase):
        def setUp(self):
            self.td = tempfile.mkdtemp()

        def tearDown(self):
            shutil.rmtree(self.td)

        def tttest_all(self):
            r = Reporter(self.td, [LOG], [
                                            OverviewReport(self.td),
                                            ProtocolAnalysis(self.td),
                                            TopSources(self.td, 10),
                                            TopDestinations(self.td, 10),
                                            TopSourcePorts(self.td, 10),
                                            TopDestinationPorts(self.td, 10)
                                        ]
                                )
