from distutils.core import setup
import glob

glades = glob.glob('src/glade/*.glade')
plugins = glob.glob('src/plugins/*.py')
icons = glob.glob('src/icons/*.png')
    
setup(name='Pympd',
        version='0.07',
        description='Rhythmbox-like GTK+ client for the Music Player Daemon (MPD).',
        author='',
        author_email='',
        url='http://pympd.sourceforge.de',
        classifiers=[
            'Development Status :: 4 - Beta',
            'Environment :: X11 Applications',
            'Intended Audience :: End Users/Desktop',
            'License :: GNU General Public License (GPL)',
            'Operating System :: Linux',
            'Programming Language :: Python',
            'Topic :: Multimedia :: Sound :: Players',
            ],
        package_dir= {'pympd':'src'},
        packages=['pympd', 'pympd.modules'],
        package_data={'pympd.modules': ['trayicon.so']},
        data_files=[('share/pympd/glade', glades + ['pympd.svg']), ('share/pympd/plugins', plugins), ('share/pixmaps', ['pympd.svg']), ('share/pympd/', ['pympd.svg']), ('share/applications', ['pympd.desktop']), ('share/pympd/pixmaps',icons) ],
        
        scripts = ['pympd']
     )
