/*
 * pwm/font.c
 *
 * Copyright (c) Tuomo Valkonen 1999-2000. 
 * See the included file LICENSE for details.
 */

#include <libtu/output.h>
#include <libtu/misc.h>
#include <string.h>
#include "font.h"
#include "config.h"


XFontStruct *load_font(Display *dpy, const char *fontname)
{
	XFontStruct *xfnt;
	
	xfnt=XLoadQueryFont(dpy, fontname);
	
	if(xfnt==NULL){
		warn("Could not load font \"%s\", trying \"%s\"",
			 fontname, CF_FALLBACK_FONT_NAME);
		xfnt=XLoadQueryFont(dpy, CF_FALLBACK_FONT_NAME);
		if(xfnt==NULL){
			warn("Failed loading fallback font.");
			return FALSE;
		}
	}
	
	return xfnt;
}


char *make_label(XFontStruct *fnt, const char *str, int maxw, int *wret)
{
	static const char *dots="...";
	const char *b;
	size_t len, tlen;
	int w, bw, dw;
	
	len=strlen(str);
	
	w=XTextWidth(fnt, str, len);

	if(w<=maxw){
		if(wret!=NULL)
			*wret=w;
		return scopy(str);
	}
	
	b=strchr(str, ':');
	
	if(b!=NULL){
		b++;
		b+=strspn(b, " ");
		bw=XTextWidth(fnt, str, b-str);
		
		if(w-bw<=maxw){
			if(wret!=NULL)
				*wret=w-bw;
			return scopy(b);
		}
		
		str=b;
		w=bw;
	}

	dw=XTextWidth(fnt, dots, 3);
	
	while(len--){
		w=XTextWidth(fnt, str, len);
		if(w+dw<=maxw)
			break;
	}
	
	if(wret!=NULL)
		*wret=w+dw;
	
	return scatn(str, len, dots, 3);
}
