#ifndef HAVE_FAKECHROOT_H
# define HAVE_FAKECHROOT_H 1

# if defined(INCLUDE_IO_WRAPPERS) && defined(WITH_VIRTUAL_CHROOT)

#  ifndef FAKECHROOT_FUNCS_DEFINITION
int fakechroot(const char *path);
#   define chroot(A) fakechroot(A)

char *fakegetcwd(char *dir, size_t size);
#   define getcwd(A, B) fakegetcwd(A, B)

int fakechdir(const char *dir);
#   define chdir(A) fakechdir(A)

int fakestat(const char *file, struct stat *st);
#   define stat(A, B) fakestat(A, B)

int fakelstat(const char *file, struct stat *st);
#   define lstat(A, B) fakelstat(A, B)

FILE *fakefopen(const char *file, const char *mode);
#   define fopen(A, B) fakefopen(A, B)

int fakeaccess(const char *file, mode_t mode);
#   define access(A, B) fakeaccess(A, B)

int fakeunlink(const char *file);
#   define unlink(A) fakeunlink(A)

DIR *fakeopendir(const char *file);
#   define opendir(A) fakeopendir(A)

int fakechmod(const char *file, mode_t mode);
#   define chmod(A, B) fakechmod(A, B)

int fakemkdir(const char *file, mode_t mode);
#   define mkdir(A, B) fakemkdir(A, B)

int fakermdir(const char *file);
#   define rmdir(A) fakermdir(A)

#   ifdef HAVE_UTIME
int fakeutime(const char *file, struct utimbuf *buf);
#    define utime(A, B) fakeutime(A, B)
#   endif

#   ifdef HAVE_UTIMES
int fakeutimes(const char *file, struct timeval *buf);
#    define utimes(A, B) fakeutimes(A, B)
#   endif

int fakechown(const char *file, uid_t uid, gid_t gid);
#   define chown(A, B, C) fakechown(A, B, C)

#   ifdef HAVE_MKFIFO
int fakemkfifo(const char *file, mode_t mode);
#    define mkfifo(A, B) fakemkfifo(A, B)
#   endif

#   ifdef HAVE_MKNOD
int fakemknod(const char *file, mode_t mode, dev_t dev);
#    define mknod(A, B, C) fakemknod(A, B, C)
#   endif

int fakelink(const char *oldpath, const char *newpath);
#   define link(A, B) fakelink(A, B)

int fakesymlink(const char *oldpath, const char *newpath);
#   define symlink(A, B) fakesymlink(A, B)

int fakereadlink(const char *file, char *buf, size_t bufsiz);
#   define readlink(A, B, C) fakereadlink(A, B, C)

int fakerename(const char *oldpath, const char *newpath);
#   define rename(A, B) fakerename(A, B)

int fakeopen(const char *file, int flags, ...);
#   define open fakeopen

#   if STATFS_TYPE == 1
int fakestatvfs64(const char *path, STATFS_STRUCT *str);
#    define statvfs64(A, B) fakestatvfs64(A, B)
#   elif STATFS_TYPE == 2
int fakestatvfs(const char *path, STATFS_STRUCT *str);
#    define statvfs(A, B) fakestatvfs(A, B)
#   elif STATFS_TYPE == 3
int fakestatfs(const char *path, STATFS_STRUCT *str);
#    define statfs(A, B) fakestatfs(A, B)
#   endif            

#  endif

# endif

#endif
