
DSN = 'dbname=test user=test'
TABLE = 'binarytest'

#### there should be no need to modify anything below this line

import psycopg, threading, whrandom
from psycopg import ProgrammingError

if len(sys.argv) != 2:
    sys.stderr.write("Usage: %s filein fileout\n")

# obtain a connection and obtain a cursor to create the tables
o = psycopg.connect(DSN)
c = o.cursor()

# create the table
create = 'CREATE TABLE %s (p1 point, p2 point, b box)' % TABLE

try:
    print "Creating table", TABLE
    c.execute(create)
except ProgrammingError:
    print "Warning:", TABLE, "already exists, dropping and re-creating"
    c.execute('DROP TABLE %s' % TABLE)
    c.execute(create)
c.commit()

# select nothing only to get column description
c.execute("SELECT b FROM %s" % TABLE)
boxoid = c.description[0][1]

# and build user type object
BOX = psycopg.new_type((boxoid,), "BOX", makeRect)
psycopg.register_type(BOX)

# now insert 100 random data (2 points and a box)
for i in range(100):
    p1 = (whrandom.randint(0,100), whrandom.randint(0,100))
    p2 = (whrandom.randint(0,100), whrandom.randint(0,100))
    b = Rect(whrandom.randint(0,100), whrandom.randint(0,100),
             whrandom.randint(0,100), whrandom.randint(0,100))
    c.execute("INSERT INTO %(table)s VALUES ('%(p1)s', '%(p2)s', %(box)s)",
              {'box':b, 'p1':p1, 'p2':p2, 'table':TABLE})
c.commit()

# select and print box
c.execute("SELECT b FROM %s WHERE p1 @ b OR p2 @ b" % TABLE)
boxes = c.fetchall()
print "FOUND %d BOXES" % len(boxes)
for b in boxes:
    print b[0].show()
