# this script test the thread-safetness of the pgpy database adapter.
# we need a clean database and a user and password for the connection,
# so, please, modify the lines below as you need.

import psycopg, threading, DateTime, sys
from psycopg import *

DSN = 'dbname=test user=test'
TABLE = 'typetest'
TYPES = [INTEGER, FLOAT, NUMBER, STRING, BOOLEAN, DATE, TIME, DATETIME, BINARY]


#### there should be no need to modify anything below this line

# parse arguments (just dsn at now)
if len(sys.argv) == 2:
    DSN = sys.argv[1]

o = psycopg.connect(DSN)
c = o.cursor('dont serialize me')

# create a table full of types and fill it with a single row

create = """CREATE TABLE %(table)s (name varchar(8), buf text, intval int4,
            floatvale float4, time1 timestamp, time2 time, time3 time, date1 date,
            date2 date, interval1 interval, boaol1 boolean, nullval int4)"""
try:
    print "Creating table", TABLE
    c.execute(create, {'table':TABLE})
except ProgrammingError, err:
    print "Exception:", err
    print "Warning:", TABLE, "already exists, dropping and re-creating"
    c.execute('DROP TABLE %s' % TABLE)
    c.execute(create, {'table':TABLE})
c.commit()

c.execute("INSERT INTO %(table)s values " +
          "('one', %(buf)s, 2, 3.0, %(stamp)s, %(time)s, '13:06:27.00', " +
          "'today', %(date)s, '1 day', 'TRUE', NULL)",
          {'table':TABLE, 'date':psycopg.Date(2001, 12, 23),
           'stamp':psycopg.TimestampFromTicks(4345266),
           'time':psycopg.Time(23, 3, 12), 'buf':psycopg.Binary('aaabbbxxx')})      
c.commit()

c.execute("SELECT * FROM %s" % TABLE)

row = c.fetchone()
print "ROW DATA:", row

# does the tests on types

def test(type, typeobject):
    if typeobject == type:
        return 'YES'
    else:
        return 'NO'

for i in range(len(row)):
    print "Testing column %d:" % i
    for t in TYPES:
        print "   ", t.name, ":", test(c.description[i][1], t)



