# this script test the thread-safetness of the pgpy database adapter.
# we need a clean database and a user and password for the connection,
# so, please, modify the lines below as you need.

DSN = 'dbname=test user=test'
TABLE_A = 'test_a'
TABLE_B = 'test_b'
COMMIT_STEP = 20
SELECT_STEP = 500


#### there should be no need to modify anything below this line

import psycopg, threading, sys
from psycopg import ProgrammingError


#### this is the function called to insert 1000 rows in table a
def a_insert(o):
    """Create cursor from 'o' and insert 1000 rows."""
    name = threading.currentThread().getName()
    c = o.cursor()
    for i in range(1000):
        if not divmod(i, COMMIT_STEP)[1]:
            o.commit()
            c = o.cursor()
            print name, ": COMMIT STEP", i
        query = "INSERT INTO %s VALUES ('%d', %d)" % (TABLE_A, i, i)
        try:
            c.execute(query)
        except ProgrammingError, err:
            print name, ": an error occurred, skipping this insert"
            print name, ":", err
            sys.exit(1)
    o.commit()


#### another insert function, this one inserts 500 values in table b
def b_insert(o):
    """Create cursor from 'o' and insert 1000 rows."""
    name = threading.currentThread().getName()
    c = o.cursor()
    for i in range(1000):
        if not divmod(i, COMMIT_STEP)[1]:
            o.commit()
            c = o.cursor()
            print name, ": COMMIT STEP", i
        query = "INSERT INTO %s VALUES ('%d', %d, %f)" % \
                (TABLE_B, i, i, float(i))
        try:
            c.execute(query)
        except ProgrammingError, err:
            print name, ": an error occurred, skipping this insert"
            print name, ":", err
            sys.exit(1)
    o.commit()


#### this is a pretty strange thread that does a select and print the number
#### of rows fetched with fetchall(), the repeats, for 10 times on every table
def ab_select(o):
    """Create two cursors and use them."""
    c1 = o.cursor()
    c2 = o.cursor()
    for i in range(10000):
        select1 = "SELECT * FROM %s" % TABLE_A
        select2 = "SELECT * FROM %s WHERE value2 < %d" % (TABLE_B, i/300)
        if not divmod(i, SELECT_STEP)[1]:
            try:
                c1.execute(select1)
                l = c1.fetchall()
                print "Select: number of rows fetched from TABLE A:", len(l)
                del l
            except ProgrammingError, err:
                print "Select: an error occurred fetching from TABLE A"
                print "Select:", err
            try:
                c2.execute(select2)
                l = c2.fetchall()
                print "Select: number of rows fetched from TABLE B:", len(l)
                del l
            except ProgrammingError, err:
                print "Select: an error occurred fetching from TABLE B"
                print "Select:", err


#### main body of this program

# parse arguments (just dsn at now)
if len(sys.argv) == 2:
    DSN = sys.argv[1]

    
# obtain a connection and obtain a cursor to create the tables
o = psycopg.connect(DSN)
c1 = o.cursor()
c2 = o.cursor()

# create the tables
create1 = 'CREATE TABLE %s (name text, value int)' % TABLE_A
create2 = 'CREATE TABLE %s (name text, value1 int, value2 float)' % TABLE_B

try:
    print "Creating table", TABLE_A
    c1.execute(create1)
except ProgrammingError:
    print "Warning:", TABLE_A, "already exists, dropping and re-creating"
    c1.execute('DROP TABLE %s' % TABLE_A)
    c1.execute(create1)
o.commit()

try:
    print "Creating table", TABLE_B
    c2.execute(create2)
except ProgrammingError:
    print "Warning:", TABLE_B, "already exists, dropping and re-creating"
    c2.execute('DROP TABLE %s' % TABLE_B)
    c2.execute(create2)
o.commit()

# now we destroy the cursors, but the connection are retained and
# will speed up the creation of the cursors in the threads
del c1, c2

# start the insert threads
print "Starting INSERT threads..."
ta = threading.Thread(None, a_insert, 'Thread-A', (o,))
ta.setDaemon(0)
tb = threading.Thread(None, b_insert, 'Thread-B', (o,))
tb.setDaemon(0)
ts = threading.Thread(None, ab_select, 'Thread-S', (o,))
ts.setDaemon(0)

ta.start()
print "Thread A started"
tb.start()
print "Thread B started"
ts.start()
print "SELECT thread started"

print "Waiting for threads"
ta.join()
print "Thread A exited OK"
tb.join()
print "Thread B exited OK"
ts.join()
print "SELECT thread exited OK"

del o

