# this script test the thread-safetness of the pgpy database adapter.
# we need a clean database and a user and password for the connection,
# so, please, modify the lines below as you need.

DSN = 'dbname=test user=test'
TABLE = {'table':'test_a'}


#### main body of this program

import psycopg
from psycopg import ProgrammingError

# obtain a connection and obtain a cursor to create the tables
o = psycopg.connect(DSN)
c1 = o.cursor()
c2 = o.cursor()

print "AUTOCOMMIT ON CONNECTION IS:", o.autocommit

# create the tables
create = 'CREATE TABLE %(table)s (name text, value int)'

try:
    print "Creating table", TABLE
    c1.execute(create, TABLE)
except ProgrammingError:
    print "Warning:", TABLE, "already exists, dropping and re-creating"
    c1.execute('DROP TABLE %(table)s', TABLE)
    c1.execute(create, TABLE)
c1.commit()

# does an insertion, a select and a commit (not in autocommit mode)
print
c1.execute("INSERT INTO %(table)s VALUES (1, 2.0)", TABLE)
print "INSERTED: (1, 2.0)"
c2.execute("SELECT * FROM %(table)s", TABLE)
r = c2.fetchall()
print "SELECT RETURNED:", r
c1.commit()
print "COMMIT ON INSERT"
c2.execute("SELECT * FROM %(table)s", TABLE)
r = c2.fetchall()
print "SELECT RETURNED:", r
c2.commit()
print "COMMIT ON SELECT"
c2.execute("SELECT * FROM %(table)s", TABLE)
r = c2.fetchall()
print "SELECT RETURNED:", r


# same thing but with c2 in autocommit
c1.execute("DELETE FROM %(table)s",TABLE)
c1.commit()
c2.autocommit()

print
c1.execute("INSERT INTO %(table)s VALUES (1, 2.0)", TABLE)
print "INSERTED: (1, 2.0)"
c2.execute("SELECT * FROM %(table)s", TABLE)
r = c2.fetchall()
print "SELECT RETURNED:", r
c1.commit()
print "COMMIT ON INSERT"
c2.execute("SELECT * FROM %(table)s", TABLE)
r = c2.fetchall()
print "SELECT RETURNED:", r


# now autocommit on the insert cursor
c2.autocommit(0)
c1.autocommit(1)
c1.execute("DELETE FROM %(table)s" % TABLE)

print 
c1.execute("INSERT INTO %(table)s VALUES (1, 2.0)", TABLE)
print "INSERTED: (1, 2.0)"
c2.execute("SELECT * FROM %(table)s", TABLE)
r = c2.fetchall()
print "SELECT RETURNED:", r
c2.commit()
print "COMMIT ON SELECT"
c2.execute("SELECT * FROM %(table)s", TABLE)
r = c2.fetchall()
print "SELECT RETURNED:", r

