#!/bin/sh

PSPVC_V=0.3
FORCE_X264=1
FORCE_FFMPEG=1


if [ $# -gt 0 ]; then
	INSTALLDIR=$1
else
	INSTALLDIR=/usr/local/
fi
INST_X264=1;
INST_FFMPEG=1;
mkdir work
cd work
if [ -e $INSTALLDIR/share/pspvc/bin/x264 ]; then
	echo "X264 of PSPVC package already install"
	INST_X264=0;
fi
if [ $FORCE_X264 -eq 1 ]; then
	echo "Installer force X264 installation"
	INST_X264=1;
fi
if [ $INST_X264 -eq 1 ]; then
	tar xjvf ../archives/x264-svn-20061014.tar.bz2
	cd x264-svn/
	./configure --enable-pthread --prefix=$INSTALLDIR/share/pspvc
	if [ $? -eq 0 ]; then
		make install
		if [ $? -eq 0 ]; then
			echo  -e "\E[01;32mX264 installation completed"; tput sgr0
		else
			echo  -e "\E[01;31mERROR during compilation or installation of X264"; tput sgr0
			exit 2
		fi
	else
		echo -e "\E[01;31mERROR during configure X264"; tput sgr0
		exit 1
	fi
	cd ..
fi
if [ -e $INSTALLDIR/share/pspvc/bin/ffmpeg ]; then
	echo "FFMPEG of PSPVC package already install"
	INST_FFMPEG=0
fi
if [ $FORCE_FFMPEG -eq 1 ]; then
	echo "Installer force FFMPEG installation"
	INST_FFMPEG=1
fi
if [ $INST_FFMPEG -eq 1 ]; then
	tar xjvf ../archives/ffmpeg-0.4.9-p20061016.tar.bz2
	cd ffmpeg/
#	patch -p1 < ../../archives/ffmpeg-mh-unix.patch
#	patch -p1 < ../../archives/ffmpeg-lrintf.patch
	./configure --enable-a52 --enable-faac --enable-x264 --enable-gpl --enable-xvid --enable-pthreads --prefix=$INSTALLDIR/share/pspvc --disable-debug --extra-cflags=-I$INSTALLDIR/share/pspvc/include --extra-ldflags="-L$INSTALLDIR/share/pspvc/lib -lX11"
	if [ $? -eq 0 ]; then
		make install
		if [ $? -eq 0 ]; then
			echo  -e "\E[01;32mFFMPEG installation completed"; tput sgr0
		else
			echo  -e "\E[01;31mERROR during compilation or installation of FFMPEG"; tput sgr0
			exit 4
		fi
	else
		echo -e "\E[01;31mERROR during configure FFMPEG"; tput sgr0
		exit 3
	fi
	cd ..
fi
tar xzvf ../archives/pspvc-$PSPVC_V.tar.gz
cd pspvc-$PSPVC_V/
./configure --prefix=$INSTALLDIR
if [ $? -eq 0 ]; then
	make install
	if [ $? -eq 0 ]; then
		echo  -e "\E[01;32mPSPVC installation completed"; tput sgr0
	else
		echo  -e "\E[01;31mERROR during compilation or installation of PSPVC"; tput sgr0
		exit 5
	fi
else
	echo -e "\E[01;31mERROR during configure PSPVC"; tput sgr0
fi
cd ../..
cp archives/pspvc.desktop /usr/share/applications
rm -rf work

