/***************************************************************************
 *            list.c
 *
 *  Mon Feb  6 19:18:23 2006
 *  Copyright  2006  User
 *  Email
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "pidlist.h"
 
void pl_init(void)
{
	pl_count=0;
	pl_first=NULL;
}

void pl_add(pid_t pid,GtkWidget* wnd)
{
	pidlist *tmp;
	if(!pl_first)
	{
		pl_first=g_new(pidlist,1);
		pl_first->prev=NULL;
		tmp=pl_first;
	}
	else
	{
		tmp=pl_first;
		while(tmp->next) 
			tmp=tmp->next;
		tmp->next=g_new(pidlist,1);
		tmp->next->prev=tmp;
		tmp=tmp->next;
	}
	tmp->next=NULL;
	tmp->pid=pid;
	tmp->convertwindow=wnd;
	pl_count++;
}
 
gboolean pl_remove(pid_t pid)
{
	pidlist *todelete,*prevtodelete;
	gboolean Found=FALSE;
	todelete=pl_first;
	prevtodelete=NULL;
	while(todelete)
	{
		if(todelete->pid==pid)
		{
			if(todelete==pl_first)
				pl_first=todelete->next;
			else
				prevtodelete->next=todelete->next;
			g_free(todelete);
			todelete=NULL;
			pl_count--;
			Found=TRUE;
		}
		else
		{
			prevtodelete=todelete;
			todelete=todelete->next;
		}
	}
	return Found;
}
