
#include <cstring>
#include <cassert>

#include "string_map_impl.hh"

// prime list and hash_string taken from SGI STL with the following 
// copyright:

/*
 * Copyright (c) 1996-1998
 * Silicon Graphics Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Silicon Graphics makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Hewlett-Packard Company makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

static const unsigned int primes[] =
{
  53,         97,         193,       389,       769,
  1543,       3079,       6151,      12289,     24593,
  49157,      98317,      196613,    393241,    786433,
  1572869,    3145739,    6291469,   12582917,  25165843,
  50331653,   100663319,  201326611, 402653189, 805306457, 
  0
};

static unsigned int hash_string(const char * s) {
  unsigned int h = 0; 
  for ( ; *s; ++s)
    h = 5*h + *s;
  return h;
}

PspellStringMapImplNode * * PspellStringMapImpl::find(const char * key) {
  PspellStringMapImplNode * * i = &data[hash_string(key) % *buckets];
  while (*i != 0 && strcmp((*i)->data.first, key) != 0)
    i = &(*i)->next;
  return i;
}

const char * PspellStringMapImpl::lookup(const char * key) const 
{
  const PspellStringMapImplNode * i 
    = *((PspellStringMapImpl *)this)->find(key);
  if (i == 0) {
    return 0;
  } else {
    if (i->data.second == 0) return "";
    else return (i->data.second);
  }
}

bool PspellStringMapImpl::insert(const char * key, const char * val, 
				 bool replace) 
{
  PspellStringMapImplNode * * i = find(key);
  char * temp;
  if (*i != 0) {

    if (replace) {

      if (val == 0 || *val == '\0') {
	temp = 0;
      } else {
	temp = new char[strlen(val) + 1];
	strcpy(temp, val);
      }
      if ((*i)->data.second != 0) delete[] (*i)->data.second;
      (*i)->data.second = temp;
      return true;

    } else {
      return false;

    }

  } else {

    ++size_;
    if (size_ > *buckets) {

      resize(buckets+1);
      return insert(key, val, replace);

    } else {

      *i = new PspellStringMapImplNode();
      char * temp = new char[strlen(key) + 1];
      strcpy(temp, key);
      (*i)->data.first = temp;
      if (val == 0 || *val == '\0') {
	temp = 0;
      } else {
	temp = new char[strlen(val) + 1];
	strcpy(temp, val);
      }
      (*i)->data.second = temp;
      return true;

    }
  }
}

bool PspellStringMapImpl::remove(const char * key) {
  PspellStringMapImplNode * * i = find(key);
  if (*i == 0) {
    return false;
  } else {
    --size_;
    PspellStringMapImplNode * temp = *i;
    *i = (*i)->next;
    delete temp;
    return true;
  }
}

void PspellStringMapImpl::resize(const unsigned int * new_buckets) {
  assert (*new_buckets != 0);
  PspellStringMapImplNode * * old_data = data;
  unsigned int old_buckets = *buckets;
  clear_table(new_buckets);
  unsigned int i = 0;
  for(;i != old_buckets; ++i) {
    PspellStringMapImplNode * j = old_data[i];
    while (j != 0) {
      PspellStringMapImplNode * * k = find(j->data.first);
      *k = j;
      j = j->next;
      (*k)->next = 0;
    }
  }
  delete[] old_data;
}

PspellStringMapImpl::PspellStringMapImpl() {
  clear_table(primes);
  size_ = 0;
}

void PspellStringMapImpl::clear() {
  destroy();
  clear_table(primes);
  size_ = 0;
}

PspellStringMapImpl::PspellStringMapImpl(const PspellStringMapImpl & other) {
  copy(other);
}

PspellStringMapImpl & 
  PspellStringMapImpl::operator= (const PspellStringMapImpl & other) 
{
  destroy();
  copy(other);
  return *this;
}

PspellStringMapImpl::~PspellStringMapImpl() {
  destroy();
}

void PspellStringMapImpl::clear_table(const unsigned int * size) {
  buckets = size;
  data = new PspellStringMapImplNodePtr[*buckets];
  memset(data, 0, sizeof(PspellStringMapImplNodePtr) * (*buckets));
}

void PspellStringMapImpl::copy(const PspellStringMapImpl & other) {
  clear_table(other.buckets);
  size_ = other.size_;
  unsigned int i = 0;
  for (; i != *buckets; ++i) {
    PspellStringMapImplNode * * j0 = &other.data[i];
    PspellStringMapImplNode * * j1 = &data[i];
    while(*j0 != 0) {
      *j1 = new PspellStringMapImplNode(**j0);
      j0 = &(*j0)->next;
      j1 = &(*j1)->next;
    }
    *j1 = 0;
  }
}

void PspellStringMapImpl::destroy() {
  unsigned int i = 0;
  for (; i != *buckets; ++i) {
    PspellStringMapImplNode * j = data[i];
    while(j != 0) {
      PspellStringMapImplNode * k = j;
      j = j->next;
      delete k;
    }
  }
  //delete[] data;
}

//
// PspellStringMapImplNode methods
//

  PspellStringMapImplNode::PspellStringMapImplNode
    (const PspellStringMapImplNode & other) 
{
  data.first = new char[strlen(other.data.first) + 1];
  strcpy((char *)data.first, other.data.first);
  if (other.data.second == 0) {
    data.second = 0;
  } else {
    data.second = new char[strlen(other.data.second) + 1];
    strcpy((char *)data.second, other.data.second);
  }
}

PspellStringMapImplNode::~PspellStringMapImplNode() {
  delete[] data.first;
  if (data.second != 0) delete[] data.second;
}


//
//
//

class PspellStringMapImplEmulation : public PspellStringPairEmulation {
  unsigned int i;
  const PspellStringMapImplNode    * j;
  const PspellStringMapImplNodePtr * data;
  unsigned int size;
public:
  PspellStringMapImplEmulation(const PspellStringMapImplNodePtr * d, 
			       unsigned int s);    
  PspellStringPairEmulation * clone() const;
  void assign(const PspellStringPairEmulation *);
  bool at_end() const;
  PspellStringPair next();
};

PspellStringMapImplEmulation
::PspellStringMapImplEmulation(const PspellStringMapImplNodePtr * d, 
			       unsigned int s) 
{
  data = d;
  size = s;
  i = 0;
  while (i != size && data[i] == 0)
    ++i;
  if (i != size)
    j = data[i];
}

PspellStringPairEmulation * PspellStringMapImplEmulation::clone() const {
  return new PspellStringMapImplEmulation(*this);
}

void 
  PspellStringMapImplEmulation::assign
    (const PspellStringPairEmulation * other)
{
  *this = *(const PspellStringMapImplEmulation *)(other);
}

bool PspellStringMapImplEmulation::at_end() const {
  return i == size;
}

PspellStringPair PspellStringMapImplEmulation::next() {
  if (i == size)
    return PspellStringPair(0,0);
  PspellStringPair temp = j->data;
  j = j->next;
  if (j == 0) {
    do ++i;
    while (i != size && data[i] == 0);
    if (i != size)
      j = data[i];
  }
  return temp;
}

PspellStringPairEmulation * PspellStringMapImpl::elements() const {
  return new PspellStringMapImplEmulation(data, *buckets);
}

PspellStringMap * new_pspell_string_map() 
{
  return new PspellStringMapImpl();
}
