
#define DONT_USE_ORIGNAL_MANAGER_FUNC
#include "manager.h"

PspellManager * to_pspell_manager(PspellCanHaveError * m)
{
  return (PspellManager *) m;
}

int pspell_manager_error_number(const PspellManager * m) 
{
  return m->error_number();
}
  
const char * pspell_manager_error_message(const PspellManager * m)
{
  return m->error_message();
}

const PspellErrorExtraInfo * 
pspell_manager_error_extra_info(const PspellManager * m)
{
  return m->error_extra_info();
}

PspellConfig * pspell_manager_config(PspellManager * m)
{
  return &(m->config());
}

int pspell_manager_check(PspellManager * m, const char * word, int size)
{
  return m->check(word,size);
}

int pspell_manager_add_to_personal(PspellManager *m, 
				   const char * word, int size)
{
  return m->add_to_personal(word,size);
}

int pspell_manager_add_to_session(PspellManager *m, 
				  const char * word, int size) 
{
  return m->add_to_session(word,size);
}

const PspellWordList * pspell_manager_master_word_list(PspellManager * m)
{
  return m->master_word_list();
}

const PspellWordList * pspell_manager_personal_word_list(PspellManager * m)
{
  return m->personal_word_list();
}

const PspellWordList * pspell_manager_session_word_list(PspellManager * m)
{
  return m->session_word_list();
}

int pspell_manager_save_all_word_lists(PspellManager * m)
{
  return m->save_all_word_lists();
}

int pspell_manager_clear_session(PspellManager * m)
{
  return m->clear_session();
}

const PspellWordList * pspell_manager_suggest(PspellManager * m, 
					      const char * word, int size)
{
  return m->suggest(word,size);
}

int pspell_manager_store_replacement(PspellManager * m, 
				     const char * mis, int mis_size,
				     const char * cor, int cor_size)
{
  return m->store_replacement(mis,mis_size,cor,cor_size);
}

