/*
 * xmlconsole.cpp - dialog for interacting manually with Jabber
 * Copyright (C) 2001, 2002  Justin Karneges
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include"xmlconsole.h"

#include<qlayout.h>
#include<qpushbutton.h>
#include<qcheckbox.h>
#include<qtextedit.h>
#include"common.h"
#include"psiaccount.h"
#include"im.h"


//----------------------------------------------------------------------------
// XmlConsole
//----------------------------------------------------------------------------
XmlConsole::XmlConsole(PsiAccount *_pa, QWidget *parent, const char *name)
:QWidget(parent, name)
{
	pa = _pa;
	pa->dialogRegister(this);
	connect(pa, SIGNAL(updatedAccount()), SLOT(updateCaption()));
	connect(pa->client(), SIGNAL(xmlIncoming(const QString &)), SLOT(client_xmlIncoming(const QString &)));
	connect(pa->client(), SIGNAL(xmlOutgoing(const QString &)), SLOT(client_xmlOutgoing(const QString &)));
	updateCaption();

	QVBoxLayout *vb1 = new QVBoxLayout(this, 8);

	prompt = 0;

	te = new QTextEdit(this);
	te->setUndoRedoEnabled(false);
	te->setReadOnly(true);
	te->setTextFormat(PlainText);

	te->setPaper(QBrush(Qt::black));
	vb1->addWidget(te);

	QHBoxLayout *hb1 = new QHBoxLayout(vb1);
	ck_enable = new QCheckBox(tr("Enable"), this);
	hb1->addWidget(ck_enable);
	hb1->addStretch(1);

	QPushButton *pb;
	pb = new QPushButton(tr("Clear"), this);
	pb->setMinimumWidth(80);
	connect(pb, SIGNAL(clicked()), te, SLOT(clear()));
	hb1->addWidget(pb);

	pb = new QPushButton(tr("&XML Input..."), this);
	pb->setMinimumWidth(80);
	connect(pb, SIGNAL(clicked()), SLOT(insertXml()));
	hb1->addWidget(pb);

	pb = new QPushButton(tr("&Close"), this);
	pb->setMinimumWidth(80);
	connect(pb, SIGNAL(clicked()), SLOT(close()));
	hb1->addWidget(pb);

	resize(560,400);
}

XmlConsole::~XmlConsole()
{
	pa->dialogUnregister(this);
}

void XmlConsole::updateCaption()
{
	setCaption(pa->name() + ": " + tr("XML Console"));
}

void XmlConsole::enable()
{
	ck_enable->setChecked(true);
}

void XmlConsole::client_xmlIncoming(const QString &str)
{
	if(ck_enable->isChecked()) {
		te->setColor(Qt::yellow);
		te->append(str + '\n');
	}
}

void XmlConsole::client_xmlOutgoing(const QString &str)
{
	if(ck_enable->isChecked()) {
		te->setColor(Qt::red);
		te->append(str + '\n');
	}
}

void XmlConsole::insertXml()
{
	if(prompt)
		bringToFront(prompt);
	else {
		prompt = new XmlPrompt(this);
		connect(prompt, SIGNAL(textReady(const QString &)), SLOT(xml_textReady(const QString &)));
		prompt->show();
	}
}

void XmlConsole::xml_textReady(const QString &str)
{
	pa->client()->send(str);
}


//----------------------------------------------------------------------------
// XmlPrompt
//----------------------------------------------------------------------------
XmlPrompt::XmlPrompt(QWidget *parent, const char *name)
:QDialog(parent, name, false, WDestructiveClose)
{
	setCaption(tr("XML Input"));

	QVBoxLayout *vb1 = new QVBoxLayout(this, 8);

	te = new QTextEdit(this);
	vb1->addWidget(te);

	QHBoxLayout *hb1 = new QHBoxLayout(vb1);
	QPushButton *pb;

	pb = new QPushButton(tr("&Transmit"), this);
	pb->setDefault(TRUE);
	connect(pb, SIGNAL(clicked()), SLOT(doTransmit()));
	hb1->addWidget(pb);
	hb1->addStretch(1);

	pb = new QPushButton(tr("&Close"), this);
	connect(pb, SIGNAL(clicked()), SLOT(close()));
	hb1->addWidget(pb);

	resize(320,240);
}

XmlPrompt::~XmlPrompt()
{
}

void XmlPrompt::doTransmit()
{
	QString str = te->text();
	textReady(str);
	close();
}

