/*
 *  output.c
 *  
 *
 *  Created by Charles Mercadal on Thu Oct 16 2003.
 *
 */
 
#include <sys/ioctl.h>
 
#include <curses.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


#include "output.h"


static void makeformatting(void);
static void printdetails(struct psinfo *);


/* 
 * NB:  All output assumes 1 processor, at most 100% total CPU usage.  
 * This should be fixed.
 */

char *rulers;
char *numbers;
char *prline;
WINDOW *topruler;
WINDOW *psgraph;

void initscreen(void)
{

    /* curses set up */
    initscr();
    clear();
    
    topruler = psgraph = NULL;
    rulers = numbers = prline = NULL;
}


/* make the pads, make the windows, or remake them */
void paintscreen(struct psinfo *procs)
{

    if (topruler == NULL) {	/* first screen paint, set up */
        /* make windows */
        topruler = newwin(5, 0, 0, 0);
        psgraph = newwin(0, 0, 5, 0);
        scrollok(psgraph, TRUE);
        
         /* set up rulers, etc.*/
        makeformatting();
        
        printdetails(procs);
    } else {	/* window resize,  free stuff, then redraw */
        struct winsize newsize;
        
        if (!ioctl(STDOUT_FILENO, TIOCGWINSZ, &newsize)) {
            resizeterm(newsize.ws_row, newsize.ws_col);
            wrefresh(curscr);
        }
        
        wclear(psgraph);
        wclear(topruler);
        
        /* goodbye windows */
        delwin(psgraph);
        delwin(topruler);
        
        /* re-make windows */
        topruler = newwin(5, 0, 0, 0);
        psgraph = newwin(0, 0, 5, 0);
        scrollok(psgraph, TRUE);
        
        /* remove memory associated with ruler, etc. before remaking them */
        free(rulers);
        free(prline);
        free(numbers);
        
        /* set up rulers, etc.*/
        makeformatting();
        
        /* re-print details in new top */
        printdetails(procs);
    }
}


/*
+------------------+-------------------+-------------------+-------------------+
0%                25%                 50%                 75%               100%
+------------------+-------------------+-------------------+-------------------+
*/
void makeformatting(void)
{
    register int cnt, len;
    

    len = COLS - 2;
    
    /* format the printable lines */
    (void)asprintf(&rulers, "%*s%*s%*s%*s%*s", 0, "+", (len / 4), "+", (len / 4), "+", (len / 4), "+", (len / 4), "+");
    (void)asprintf(&numbers, "%*s%*s%*s%*s%*s", 0, "0%", (len / 4), "25%", (len / 4), "50%", (len / 4), "75%", (len / 4) - 1, "100%");
    (void)asprintf(&prline, "%*s%*s%*s%*s%*s", 0, ".", (len / 4), ".", (len / 4), ".", (len / 4), ".", (len / 4), ".");
    
    /* add some filler to the rulers */
    for (cnt = 0; cnt < strlen(rulers); cnt++)
        if (rulers[cnt] == ' ') rulers[cnt] = '-';
}


void printdetails(struct psinfo *procs)
{
    
    (void)wprintw(topruler, "pid:%6d\tname: %s\n", procs->psnum, procs->psname);
    (void)wprintw(topruler, "%s\n%s\n%s\n", rulers, numbers, rulers);
    wrefresh(topruler);
}


void printinfo(struct psinfo *procs)
{
    register int index;

        
    if ((index = (int)(procs->cpu * strlen(prline) / 100))) {
        wattron(psgraph, A_REVERSE);
        wprintw(psgraph, "%.*s", index, prline);
        wattroff(psgraph, A_REVERSE);
    }
    
    for ( ; index < strlen(prline); index++)
        waddch(psgraph, (chtype)prline[index]);
    
    waddch(psgraph, '\n');
    wrefresh(psgraph);
}


/*
 * Should be called at application exit
 */
void resetdisplay(void)
{

    free(rulers);
    free(numbers);
    free(prline);
    attrset(A_NORMAL);
    endwin();
}

