#include "signals.h"
#include <iostream.h>

// Jump back to wherever we started this BASIC thing
// NOTE! This function isn't part of the signals class because complaints
// about type conversions are given when compiling with g++, to be fixed
void
jmpBack(int signo) {
  if (signo == SIGINT)
    longjmp(jmpbuffer, 1);
}

signals::signals() {
}

/* This ignores the SIGPIPE signal. This is usually a good idea, since the default
   behaviour is to terminate the application. SIGPIPE is sent when you try to write
   to an unconnected socket. You should check your return codes to make sure you
   catch this error! */
void
signals::ignoreSIGPIPE()
{
  sigaction(SIGPIPE, NULL, &action);
  action.sa_handler = SIG_IGN;
  sigaction(SIGPIPE, &action, NULL);
}

// Enable SIGINT handler
void
signals::enableSIGINTHandler() {
  // Change sa_handler for SIGINT to call function
  sigaction(SIGINT, NULL, &action);
  action.sa_handler = jmpBack;
  sigaction(SIGINT, &action, NULL);
}

// Reset SIGINT to default action
void
signals::resetSIGINTHandler() {
  // Restore default action to SIGINT
  sigfillset(&mask);
  sigdelset(&mask, SIGINT);
  sigprocmask(SIG_SETMASK, &mask, NULL);
  action.sa_handler = SIG_DFL;
  sigaction(SIGINT, &action, NULL);
}

signals::~signals() {
}
