#ifndef _POP_H
#define _POP_H

#include "header.h"
#include "sockets.h"
#include "alloc.h"
#include "prefs.h"
#include "util.h"
#include <ctype.h>
#include <iostream.h>    // Debugging only, remove later

extern sockets* ptrSockets;
extern header* ptrHeader;
extern alloc* ptrAlloc;
extern prefs* ptrPrefs;
extern util* ptrUtil;

/* Functions return 0 if unsuccessful => pointer "error" = message without the "-ERR "
 * Functions return 1 if successful => pointer "output" = message without the "-OK " */

class POP
{
 private:
  char command[512];
  char buffer[512];
  char CRLF[2];
  //char* timeStamp;
  int i;
 public:
  POP();
  int serverConnect();
  int serverLogin();
  int serverLogout();
  int serverSTAT();
  int serverShortLIST();
  int serverLongLIST(int num);
  int serverCmd(char* input);
  int serverCmdRead(int num);
  char* message;
  const char* output;
  const char* error;
  char* host;
  char* port;
  char* user;
  char* pass;
  int connect;
  int login;
  ~POP();
};

#endif
