#include "pop.h"

POP::POP()
{
  connect = 0;
  login = 0;
  
  CRLF[0] = 13;
  CRLF[1] = 10;
  
  host = port = user = pass = message = '\0';
}

// Connect to server
int
POP::serverConnect() {
  if (!ptrSockets->makeConnection(host, port, SOCK_STREAM))
    return(0);
  
  if (!ptrSockets->sockGets(buffer, sizeof(buffer)-1)) {
    return(0);
  }
  ptrUtil->strCpy(message, buffer);
  
  /*
  // Extract timestamp in greeting used for APOP authentication
  ptrAlloc->freeMem(timeStamp);
  for (i=0; message[i]; i++) {
    if (message[i] == '<') {
      timeStamp = ptrAlloc->allocMem(strlen(&message[i])+1);
      strcpy(timeStamp, &message[i]);
      break;
    }
  }
  */
  
  connect = 1;
  return(1);
}

// Login to server
int
POP::serverLogin() {
  strcpy(command, "USER ");
  strcat(command, user);
  if (!serverCmd(command))
    return(0);
  
  strcpy(command, "PASS ");
  strcat(command, pass);
  if (!serverCmd(command))
    return(0);
  
  login = 1;
  return(1);
}

// Logout from server
int
POP::serverLogout() {  
  strcpy(command, "QUIT");
  if (!serverCmd(command)) {
    connect = 0;
    login = 0;
    return(0);
  }
  
  connect = 0;
  login = 0;
  return(1);
}

// Execute STAT and put result into maxNumber and maxSize
int
POP::serverSTAT() {
  strcpy(command, "STAT");
  
  if (serverCmd(command)) {
    ptrHeader->maxNumber = atoi(message+4);
    output = strstr(message+4, " ") + 1;
    ptrHeader->maxSize = atol(output);
    return(1);
  }
  else
    return(0);
}

// Execute LIST and put result into maxNumber and size[] in header class
int
POP::serverShortLIST() {
  strcpy(command, "LIST");
  
  if (serverCmd(command)) {
    output = strstr(message+4, "\n");
    if (output != NULL)
      output++;
    else {
      ptrUtil->strCpy(message, "-ERR No messages on server");
      return(0);
    }
    
    while (true) {
      i = atoi(output);
      output = strstr(output, " ");
      if (output == NULL)
	break;
      output++;
      ptrHeader->size[i] = atol(output);
      output = strstr(output, "\n");
      if (output == NULL)
	break;
      output++;
    }
    
    ptrHeader->maxNumber = i;
    if (MAXMSG < ptrHeader->maxNumber) {
      ptrUtil->strCpy(message, "-ERR prepop hasn't been compiled to handle this many messages");
      return(0);
    }
    
    return(1);
  }
  else
    return(0);
}

// Execute TOP and extract headers for message into arrays in header class
int
POP::serverLongLIST(int num) {
  strcpy(command, "TOP ");
  strcat(command, ptrUtil->intToASCII(num));
  strcat(command, " 0");
  
  if (!serverCmd(command))
    return(0);
  
  ptrAlloc->freeMem(ptrHeader->from[num]);
  ptrAlloc->freeMem(ptrHeader->subject[num]);
  ptrAlloc->freeMem(ptrHeader->date[num]);
  ptrAlloc->freeMem(ptrHeader->contType[num]);
  ptrAlloc->freeMem(ptrHeader->charSet[num]);
  ptrAlloc->freeMem(ptrHeader->contTransEnc[num]);
  ptrAlloc->freeMem(ptrHeader->boundary[num]);
  ptrAlloc->freeMem(ptrHeader->xSender[num]);
  ptrAlloc->freeMem(ptrHeader->xMailer[num]);
  ptrAlloc->freeMem(ptrHeader->xPriority[num]);
  
  ptrHeader->from[num] = ptrHeader->getHeader(message+4, "From:");
  ptrHeader->subject[num] = ptrHeader->getHeader(message+4, "Subject:");
  ptrHeader->date[num] = ptrHeader->getHeader(message+4, "Date:");
  ptrHeader->contType[num] = ptrHeader->getHeader(message+4, "Content-Type:");
  ptrHeader->charSet[num] = ptrHeader->getHeader(ptrHeader->contType[num], "charset=");
  ptrHeader->contTransEnc[num] = ptrHeader->getHeader(message+4, "Content-Transfer-Encoding:");
  ptrHeader->boundary[num] = ptrHeader->getHeader(ptrHeader->contType[num], "boundary=");
  ptrHeader->xSender[num] = ptrHeader->getHeader(message+4, "X-Sender:");
  ptrHeader->xMailer[num] = ptrHeader->getHeader(message+4, "X-Mailer:");
  ptrHeader->xPriority[num] = ptrHeader->getHeader(message+4, "X-Priority:");

  ptrHeader->from[num] = ptrHeader->decodeHeaderQP(ptrHeader->from[num]);
  ptrHeader->subject[num] = ptrHeader->decodeHeaderQP(ptrHeader->subject[num]);
  ptrHeader->from[num] = ptrHeader->decodeHeaderB(ptrHeader->from[num]);
  ptrHeader->subject[num] = ptrHeader->decodeHeaderB(ptrHeader->subject[num]);
  
  // Fix empty headers to default values and "niceify" them
  ptrHeader->fixFrom(ptrHeader->from[num]);
  ptrHeader->fixDate(ptrHeader->date[num]);
  ptrHeader->fixContType(ptrHeader->contType[num]);
  ptrHeader->fixCharSet(ptrHeader->charSet[num]);
  ptrHeader->fixContTransEnc(ptrHeader->contTransEnc[num]);
  ptrHeader->fixBoundary(ptrHeader->boundary[num]);
  ptrHeader->fixXSender(ptrHeader->xSender[num]); 
  
  return(1);
}

// Send a POP3 (RFC 1939, 2449) command to server
int
POP::serverCmd(char* input) {  
  char* dot;
  char* end;
  
  if (connect == 0) {
    ptrUtil->strCpy(message, "-ERR You are not connected to any server");
    return(0);
  }
  
  ptrUtil->strCpy(message, "");
  strcpy(buffer, "");
  strcat(input, CRLF);
  
  // Drain socket if unretrieved data
  ptrSockets->readToEOF();
  
  ptrSockets->sockPuts(input);
  if ((strncasecmp(input, "LIST", 4) == 0) ||
      (strncasecmp(input, "RETR", 4) == 0) ||
      (strncasecmp(input, "TOP", 3) == 0) ||
      (strncasecmp(input, "CAPA", 4) == 0)) {
    ptrSockets->sockGets(buffer, sizeof(buffer)-1);
    ptrUtil->strCat(message, buffer);
    strcpy(buffer, "");
    if (strncmp(message, "-ERR", 4) != 0) {
      ptrUtil->strCat(message, "\n");
      while (strcmp(buffer, ".") != 0) {
	if (ptrSockets->sockGets(buffer, sizeof(buffer)-1) == -2) {
	  ptrUtil->strCpy(message, "-ERR Server timeout, please login again");
	  return(0);
	}
	
	// Perform "byte-destuffing"
	dot = buffer;
	if ((dot[0] == '.') && (dot[1] != '\n'))
	  dot++;
	ptrUtil->strCat(message, dot);
	ptrUtil->strCat(message, "\n");
      }
    }
    else
      return(0);
  }
  else {
    if (ptrSockets->sockGets(buffer, sizeof(buffer)-1) == -2) {
      ptrUtil->strCpy(message, "-ERR Server timeout, please login again");
      return(0);
    }
    
    //ptrSockets->sockGets(buffer, sizeof(buffer)-1);
    ptrUtil->strCpy(message, buffer);
  }
  
  // Remove all whitespaces at end of body
  for (end = &message[strlen(message)-1]; isspace(*end); end--)
    *end = '\0';
  
  // If server only returns response codes and no message
  if (strcmp(message, "+OK") == 0)
    ptrUtil->strCat(message, " N/A");
  if (strcmp(message, "-ERR") == 0)
    ptrUtil->strCat(message, " N/A");
  
  if (strncmp(message, "+OK", 3) == 0)
    return(1);
  else
    return(0);
}

// Read a message with TOP command (parse header if non-existent)
// This was made as a try to parse the socket directly, I have no idea to why
// I made it this way, this routine will be rewritten to first retrieve
// all data and then parse the buffer in memory which will make it _so_ much
// easier to understand.
int
POP::serverCmdRead(int num) {
  char* dot;
  char* sBoundary;
  char* contType;
  char* contTransEnc;
  char* start;
  char* end;
  
  if (connect == 0) {
    ptrUtil->strCpy(message, "-ERR You are not connected to any server");
    return(0);
  }
  
  // This is a very ugly fix, but it works
  if (MAXMSG < ptrHeader->maxNumber) {
    ptrUtil->strCpy(message, "-ERR prepop hasn't been compiled to handle this many messages");
    return(0);
  }
  
  strcpy(command, "TOP ");  
  strcat(command, ptrUtil->intToASCII(num));
  strcat(command, " ");
  strcat(command, ptrUtil->intToASCII(ptrPrefs->numFetchLines));
  strcat(command, CRLF);
  
  // Drain socket if unretrieved data
  ptrSockets->readToEOF();
  
  ptrSockets->sockPuts(command);
  if (ptrSockets->sockGets(buffer, sizeof(buffer)-1) == -2) {
    ptrUtil->strCpy(message, "-ERR Server timeout, please login again");
    return(0);
  }
  
  //ptrSockets->sockGets(buffer, sizeof(buffer)-1);
  
  ptrUtil->strCpy(message, buffer);
  
  if (strncmp(message, "-ERR", 4) == 0)
    return(0);
  
  ptrUtil->strCat(message, "\n");
  
  // Retrieve the top header with TOP command
  do {
    ptrSockets->sockGets(buffer, sizeof(buffer)-1);
    ptrUtil->strCat(message, buffer);
    ptrUtil->strCat(message, "\n");
  }
  while (strlen(buffer) > 0);
  
  // Extract headers from top header (if not downloaded already)
  if (ptrHeader->from[num] == '\0') {
    ptrAlloc->freeMem(ptrHeader->from[num]);
    ptrAlloc->freeMem(ptrHeader->subject[num]);
    ptrAlloc->freeMem(ptrHeader->date[num]);
    ptrAlloc->freeMem(ptrHeader->contType[num]);
    ptrAlloc->freeMem(ptrHeader->charSet[num]);
    ptrAlloc->freeMem(ptrHeader->contTransEnc[num]);
    ptrAlloc->freeMem(ptrHeader->boundary[num]);
    ptrAlloc->freeMem(ptrHeader->xSender[num]);
    ptrAlloc->freeMem(ptrHeader->xMailer[num]);
    ptrAlloc->freeMem(ptrHeader->xPriority[num]);
    
    ptrHeader->from[num] = ptrHeader->getHeader(message+4, "From:");
    ptrHeader->subject[num] = ptrHeader->getHeader(message+4, "Subject:");
    ptrHeader->date[num] = ptrHeader->getHeader(message+4, "Date:");
    ptrHeader->contType[num] = ptrHeader->getHeader(message+4, "Content-Type:");
    ptrHeader->charSet[num] = ptrHeader->getHeader(ptrHeader->contType[num], "charset=");
    ptrHeader->contTransEnc[num] = ptrHeader->getHeader(message+4, "Content-Transfer-Encoding:");
    ptrHeader->boundary[num] = ptrHeader->getHeader(ptrHeader->contType[num], "boundary=");
    ptrHeader->xSender[num] = ptrHeader->getHeader(message+4, "X-Sender:");
    ptrHeader->xMailer[num] = ptrHeader->getHeader(message+4, "X-Mailer:");
    ptrHeader->xPriority[num] = ptrHeader->getHeader(message+4, "X-Priority:");
    
    ptrHeader->from[num] = ptrHeader->decodeHeaderQP(ptrHeader->from[num]);
    ptrHeader->subject[num] = ptrHeader->decodeHeaderQP(ptrHeader->subject[num]);
    ptrHeader->from[num] = ptrHeader->decodeHeaderB(ptrHeader->from[num]);
    ptrHeader->subject[num] = ptrHeader->decodeHeaderB(ptrHeader->subject[num]);
    
    ptrHeader->fixFrom(ptrHeader->from[num]);
    ptrHeader->fixDate(ptrHeader->date[num]);
    ptrHeader->fixContType(ptrHeader->contType[num]);
    ptrHeader->fixCharSet(ptrHeader->charSet[num]);
    ptrHeader->fixContTransEnc(ptrHeader->contTransEnc[num]);
    ptrHeader->fixBoundary(ptrHeader->boundary[num]);
    ptrHeader->fixXSender(ptrHeader->xSender[num]);
  }
  
  // Set status of command for pointer (+4)
  ptrUtil->strCpy(message, "+OK\n");  
  
  // If message is NOT multipart
  if (strncmp(ptrHeader->contType[num], "text/plain", 10) == 0) {
    
    // Extract message body and decode quoted-printable if necessary
    while (strcmp(buffer, ".") != 0) {
      ptrSockets->sockGets(buffer, sizeof(buffer)-1);
      // Perform "byte-destuffing"
      dot = buffer;
      if ((dot[0] == '.') && (dot[1] != '\n'))
	dot++;
      // Decide if message is QP encoded or not
      if (strncmp(ptrHeader->contTransEnc[num], "quoted-printable", 16) == 0)
	ptrUtil->strCat(message, ptrHeader->decodeBodyQP(dot));
      else {
	ptrUtil->strCat(message, dot);
	ptrUtil->strCat(message, "\n");
      }
    }
    
  }
  
  // If message is multipart
  if (strncmp(ptrHeader->contType[num], "multipart/", 10) == 0) {
    
    // Setup start boundary, "--" added at start
    sBoundary = ptrAlloc->allocMem(strlen(ptrHeader->boundary[num])+3);
    strcpy(sBoundary, "--");
    strcat(sBoundary, ptrHeader->boundary[num]);
    
    // Search until sBoundary is found
    while (strcmp(buffer, sBoundary) != 0) {
      ptrSockets->sockGets(buffer, sizeof(buffer)-1);
      if (strcmp(buffer, ".") == 0)
	break;
    }
    
    // Copy header of message part to message variable
    do {
      ptrSockets->sockGets(buffer, sizeof(buffer)-1);
      if (strcmp(buffer, ".") == 0)
	break;
      ptrUtil->strCat(message, buffer);
      ptrUtil->strCat(message, "\n");
    }
    while (strlen(buffer) > 0);
    
    // Extract Content-Type and Content-Transfer-Encoding
    contType = ptrHeader->getHeader(message, "Content-Type:");
    contTransEnc = ptrHeader->getHeader(message, "Content-Transfer-Encoding:");
    ptrHeader->fixContType(contType);
    ptrHeader->fixContTransEnc(contTransEnc);
    
    // Set status of command for pointer (+4)
    ptrUtil->strCpy(message, "+OK\n");      
    
    // If message part is of type text/plain, copy it to the message variable
    // Decode quoted-printable if necessary
    if (strncmp(contType, "text/plain", 10) == 0) {
      while (true) {
	ptrSockets->sockGets(buffer, sizeof(buffer)-1);
	if ((strcmp(buffer, ".") == 0) || (strcmp(buffer, sBoundary) == 0))
	  break;
	// Perform "byte-destuffing"
	dot = buffer;
	if ((dot[0] == '.') && (dot[1] != '\n'))
	  dot++;
	// Decide if message is QP encoded or not
	if (strncmp(contTransEnc, "quoted-printable", 16) == 0)
	  ptrUtil->strCat(message, ptrHeader->decodeBodyQP(dot));
	else {
	  ptrUtil->strCat(message, dot);
	  ptrUtil->strCat(message, "\n");
	}
      }
    }
    
    // Free allocated memory
    ptrAlloc->freeMem(sBoundary);
    ptrAlloc->freeMem(contType);
    ptrAlloc->freeMem(contTransEnc);
  }
  
  // Drain socket on data
  ptrSockets->readToEOF();
  
  // Remove all newline chars at start of body
  start = message + 4; // "+OK\n"
  while ((*start == '\n') && *start)
    start++;
  memmove(message + 4, start, strlen(message));
  
  // Remove all whitespaces and '.' at end of body
  for (end = &message[strlen(message)-1]; *end && (isspace(*end) || (*end == '.')); end--)
    *end = '\0';
  
  // If server only returns response codes and no message
  if (strcmp(message, "+OK") == 0)
    ptrUtil->strCat(message, " N/A");
  if (strcmp(message, "-ERR") == 0)
    ptrUtil->strCat(message, " N/A");
  
  if (strncmp(message, "+OK", 3) == 0)
    return(1);
  else
    return(0);
}

POP::~POP()
{
}
