#ifndef _HEADER_H
#define _HEADER_H

#include "alloc.h"
#include "prefs.h"
#include "util.h"
#include "base64.h"
#include "config.h"
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <iostream.h> // Used for debugging only - remove later

extern alloc* ptrAlloc;
extern base64* ptrBase64;
extern prefs* ptrPrefs;
extern util* ptrUtil;

class header
{
 private:
  int i;
 public:
  header();
  char* getHeader(const char* input, const char* search);
  char* decodeHeaderQP(char* input);
  char* decodeHeaderB(char* input);
  void fixFrom(char* &input);
  void fixContType(char* &input);
  void fixCharSet(char* &input);
  void fixContTransEnc(char* &input);
  void fixBoundary(char* &input);
  void fixXSender(char* &input);
  void fixDate(char* &input);
  char* decodeBodyQP(char* input);
  long int size[MAXMSG];
  char* from[MAXMSG];
  char* subject[MAXMSG];
  char* date[MAXMSG];
  char* contType[MAXMSG];
  char* charSet[MAXMSG];
  char* contTransEnc[MAXMSG];
  char* boundary[MAXMSG];
  char* xSender[MAXMSG];
  char* xMailer[MAXMSG];
  char* xPriority[MAXMSG];
  int numArgs[MAXMSG];
  int maxNumber;
  long int maxSize;
  ~header();
};

#endif
