#include "header.h"

header::header()
{
  for (i=0; i<MAXMSG; i++) {
    size[i] = 0;
    from[i] = subject[i] = date[i] = contType[i] = charSet[i] = '\0';
    contTransEnc[i] = boundary[i] = xSender[i] = xMailer[i] = xPriority[i] = '\0';
  }
  
  maxNumber = maxSize = 0;
}

// Extract header from top header
char*
header::getHeader(const char* input, const char* search) {
  char buffer[512];
  const char* start = input;
  char* dynamic;
  
  if (input == '\0')
    return('\0');
  
  // Do case-insensitive search for "search" in "input"
  while (*start) {
    if (strncasecmp(start, search, strlen(search)) == 0)
      break;
    start++;
  }
  if (*start == '\0')
    return('\0');
  start += strlen(search);
  
  // Perform "unfolding" of header and remove doubles of whitespaces
  for (i=0; *start && (unsigned) i<sizeof(buffer)-1; i++) {
    if (isspace(*start)) {
      while (isspace(*start))
	start++;
      buffer[i] = ' ';
    }
    else
      buffer[i] = *start++;
    if (start[-1] == '\n')
      if (!isspace(*start))
	break;
  }
  buffer[i] = '\0';
  
  // Remove spaces at start of header
  start = buffer;
  while (isspace(*start))
    start++;
  
  if (strlen(start) == 0)
    return('\0');
  
  // Allocate memory and copy header to that space
  dynamic = ptrAlloc->allocMem(strlen(start)+1);
  strcpy(dynamic, start);
  
  return(dynamic);
}

// Decode QPs in message headers if necessary
char*
header::decodeHeaderQP(char* input) {
  char buffer[512];
  char* start = buffer;
  char* output = buffer;
  char* dynamic;
  char* inputStart = input;
  
  if (input == NULL)
    return('\0');
  
  if ((strstr(input, "?q?") == NULL) && (strstr(input, "?Q?") == NULL))
    return(input);
  
  while (*input) {
    // Check start of QP, if so jump over charset definition
    if ((*input == '=') && (input[1] == '?')) {
      if (strstr(input, "?Q?") != NULL)
	input = strstr(input, "?Q?");
      else
	input = strstr(input, "?q?");
      if (input)
	input += 3;
      else
	return(inputStart);
      while ((*input != '?') || (input[1] != '=')) {
	// Do QP conversion of hex string
	if (*input == '=') {
	  *output = ptrUtil->hexConvert(++input);
	  input++;
	}
	// Convert spaces coded as '_' to a ' ' inside a QP string
	else if (*input == '_')
	  *output = ' ';
	else
	  *output = *input;
	input++;
	output++;
      }
      input += 2;
    }
    else
    {
      *output = *input;
      // If "?= =?" is found remove space by decreasing output pointer
      // RFC 2047 doesn't specify if this is correct handling, but it works
      if ((input[-2] == '?') && (input[-1] == '=') && (*input == ' ') &&
	  (input[1] == '=') && (input[2] == '?'))
	output--;
      input++;
      output++;
    }
  }
  *output = '\0';
  
  // Replace input with new header and return it
  dynamic = ptrAlloc->allocMem(strlen(start)+1);
  strcpy(dynamic, start);
  ptrAlloc->freeMem(inputStart);
  
  return(dynamic);
}

// Decode Base64 in message headers if necessary
char*
header::decodeHeaderB(char* input) {
  char buffer[512];
  char* end;
  char* output = buffer;
  char* dynamic;
  char* inputStart = input;
  int length;
  
  if (input == NULL)
    return('\0');
  
  if ((strstr(input, "?B?") == NULL) && (strstr(input, "?b?") == NULL))
    return(input);
  
  // Check start of Base64, if so jump over charset definition
  if (strstr(input, "?B?") != NULL)
    input = strstr(input, "?B?") + 3;
  else
    input = strstr(input, "?b?") + 3;
  
  // Check end of Base64 encoded string
  end = strstr(input, "?=");
  if (end == NULL)
    return(inputStart);
  *end = '\0';
  
  length = ptrBase64->decodeBase(input, output);
  output[length] = '\0';
  
  // Replace input with new header and return it
  dynamic = ptrAlloc->allocMem(strlen(output)+1);
  strcpy(dynamic, output);
  ptrAlloc->freeMem(inputStart);
  
  return(dynamic);
}

// Fix "From:" header
void
header::fixFrom(char* &input) {
  char* start;
  char* end;
  
  if (input == '\0')
    return;
  
  // Extract "Name" if set so in prefs
  if (ptrPrefs->showFromName) {
    if (*input == '\"') {
      start = end = input+1;
      while (*end && (*end != '\"'))
	end++;
      *end = '\0';
      memmove(input, start, strlen(start)+1);
    }
    else if (*input == '<') {
      start = end = input+1;
      while (*end && (*end != '>'))
	end++;
      *end = '\0';
      memmove(input, start, strlen(start)+1);
    }
    else if (strchr(input, '(')) {
      start = end = strchr(input, '(')+1;
      while (*end && (*end != ')'))
	end++;
      *end = '\0';
      memmove(input, start, strlen(start)+1);
    }
    else {
      end = strstr(input, " <");
      if (end)
	*end = '\0';
    }
  }
  else if (strchr(input, '@')) {
    // Extract "E-mail" if set so in prefs
    start = end = strchr(input, '@');
    while (!isspace(*start) && (start>=input))
      start--;
    start++;
    while (!isspace(*end) && *end)
      end++;
    *end = '\0';
    
    if (*start == '<') {
      start++;
      end--;
      *end = '\0';
    }
    
    memmove(input, start, strlen(start)+1);
  }
}

// Fix "Date:" header
void
header::fixDate(char* &input) {
  char hmonth[3] = "";
  char hday[3] = "";
  char htime[6] = "";
  char hzone[6] = "";
  char* ptr;
  
  if (input == '\0')
    return;
  
  // month 1-12
  if (strstr(input, "Jan")) strcpy(hmonth, "01");
  else if (strstr(input, "Feb")) strcpy(hmonth, "02");
  else if (strstr(input, "Mar")) strcpy(hmonth, "03");
  else if (strstr(input, "Apr")) strcpy(hmonth, "04");
  else if (strstr(input, "May")) strcpy(hmonth, "05");
  else if (strstr(input, "Jun")) strcpy(hmonth, "06");
  else if (strstr(input, "Jul")) strcpy(hmonth, "07");
  else if (strstr(input, "Aug")) strcpy(hmonth, "08");
  else if (strstr(input, "Sep")) strcpy(hmonth, "09");
  else if (strstr(input, "Oct")) strcpy(hmonth, "10");
  else if (strstr(input, "Nov")) strcpy(hmonth, "11");
  else if (strstr(input, "Dec")) strcpy(hmonth, "12");
  
  // day 1-31
  ptr = strstr(input, ",");
  if (ptr != NULL)
    strncpy(hday, ptr+2, 2);
  else
    strncpy(hday, input, 2);
  if ((hday[0] != '0') && (hday[1] == ' ')) {
    hday[1] = hday[0];
    hday[0] = '0';
  }
  hday[2] = '\0';
  
  // time hour:min
  ptr = strstr(input, ":");
  if (ptr != NULL)
    strncpy(htime, ptr-2, 5);
  htime[5] = '\0';
  
  // zones in text "GMT" and numerical "+0000" format
  // RFC 822 specifies military format too, we currently don't care
  ptr = strchr(input, '+');
  if (!ptr)
    ptr = strchr(input, '-');
  if (ptr) {
    strncpy(hzone, ptr, 5);
    hzone[5] = '\0';
  }
  else {
    if (strstr(input, "UT")) strcpy(hzone, "+0000");
    else if (strstr(input, "UTC")) strcpy(hzone, "+0000");
    else if (strstr(input, "GMT")) strcpy(hzone, "+0000");
    else if (strstr(input, "EST")) strcpy(hzone, "-0500");
    else if (strstr(input, "EDT")) strcpy(hzone, "-0400");
    else if (strstr(input, "CST")) strcpy(hzone, "-0600");
    else if (strstr(input, "CDT")) strcpy(hzone, "-0500");
    else if (strstr(input, "MST")) strcpy(hzone, "-0700");
    else if (strstr(input, "MDT")) strcpy(hzone, "-0600");
    else if (strstr(input, "PST")) strcpy(hzone, "-0800");
    else if (strstr(input, "PDT")) strcpy(hzone, "-0700");
    else strcpy(hzone, "+0000");
  }
  
  // Build header if "month", "day", "time" and "zone" exists
  if ((strlen(hmonth)>0) && (strlen(hday)>0) &&
      (strlen(htime)>0) && (strlen(hzone)>0)) {
    strcpy(input, hday);
    strcat(input, "/");
    strcat(input, hmonth);
    strcat(input, " ");
    strcat(input, htime);
    strcat(input, " ");
    strcat(input, hzone);
  }
  else
    strcpy(input, "N/A");
}

// Fix "Content-Type:" header
void
header::fixContType(char* &input) {
  char* end = input;
  
  if (input == '\0') {
    ptrUtil->strCpy(input, "text/plain;");
    return;
  }
  
  // Lowercase and remove everything after first whitespace character
  if ((strncasecmp(input, "text/", 5) == 0) ||
      (strncasecmp(input, "multipart/", 10) == 0)) {
    while (*end && !isspace(*end))
      *end++ = tolower(*end);
    *end = '\0';
  }
  else {
    // image/gif; and others... what should we do, name="file.gif" ??
    //ptrAlloc->freeMem(input);
    //input = '\0';
  }
  
  // Fix for non RFC 2045 compliant mailheaders
  if (strncasecmp(input, "text", 4) == 0) {
    ptrAlloc->freeMem(input);
    input = ptrAlloc->allocMem(12);
    strcpy(input, "text/plain;");
  }
}

// Fix "charset=" found in "Content-Type:" header
void
header::fixCharSet(char* &input) {
  char* end = input;
  
  if (input == '\0') {
    ptrUtil->strCpy(input, "us-ascii");
    return;
  }
  
  while (*end && !isspace(*end)) {
    *end++ = tolower(*end);
    if (*end == '\"')
      break;
  }
  *end = '\0';
  
  if (*input == '\"')
    memmove(&input[0], &input[1], strlen(input));
}

// Fix "Content-Transfer-Encoding:" header
void
header::fixContTransEnc(char* &input) {
  if (input == '\0') {
    ptrUtil->strCpy(input, "7bit");
    return;
  }
  return;
}

// Fix "boundary=" found in "Content-Type:" header
void
header::fixBoundary(char* &input) {
  char* end = input;
  
  if (input == '\0')
    return;
  
  while (*end && !isspace(*end)) {
    end++;
    if (*end == '\"')
      break;
  }
  *end = '\0';
  
  if (*input == '\"')
    memmove(&input[0], &input[1], strlen(input));
}

// Fix "X-Sender:" header
void
header::fixXSender(char* &input) {
  char* end = input;
  
  if (input == '\0')
    return;
  
  while (*end && !isspace(*end))
    end++;
  *end = '\0';  
}

// Decode QPs in message bodies only
char*
header::decodeBodyQP(char* input) {
  char temp[512];
  char* start = temp;
  char* output = temp;

  while (*input) {
    if ((*input == '=') && (input[1] != '\0')) {
      *output = ptrUtil->hexConvert(++input);
      input++;
    }
    else
      *output = *input;
    input++;
    output++;
  }
  *output = '\0';
  
  // If padding "=" is done, remove and return without '\n' at end
  if (output[-1] == '=')
    output[-1] = '\0';
  else
    strcat(output, "\n");
  
  return(start);
}

header::~header()
{
}
