Summary: Point-to-Point Tunneling Protocol (PPTP) Client
Name: pptp-linux
Provides: pptp-linux
Obsoletes: pptp-scripts
Version: 1.1.0
Release: 1
#Source: http://quozl.netrek.org/pptp/pptp-linux-1.1.0.tar.gz
Source: pptp-linux-1.1.0.tar.gz
Source1: pptp-command
Source2: options.pptp
Source3: pptp_fe.pl
Source4: xpptp_fe.pl
#Patch0: ftp://ftp.us.debian.org/debian/dists/woody/main/source/net/pptp-linux_1.0.2-3.diff.gz
#Patch1: pptp-linux-1.0.2-O1.patch.gz
Copyright: GPL
Group: Applications/Internet
BuildRoot: /tmp/pptp-linux-%{version}-buildroot

%description
Client for the proprietary Microsoft Point-to-Point Tunneling
Protocol, PPTP.  Allows connection to a PPTP based VPN as used
by employers and some cable and ADSL service providers.
Requires MPPE support in kernel, use package ppp-mppe.

%changelog
* Fri Mar 22 2002 James Cameron <james.cameron@compaq.com>
- new release engineer.
- avoid requiring ppp-mppe.
- allow activation as a psuedo-tty child process from pppd.
- ADSL modem quirks handler by mulix@actcom.co.il.
- Orckit ADSL modem compatibility.
- Cisco PIX compatibility.
- enhance bad FCS error message.
- ported to FreeBSD and NetBSD.
* Sun Apr 22 2001 Scott Venier <scott.venier@compaq.com>
- change GRE decaps code to fix bad_bytes bug and a few others.
- add the LCP echo options to the ppp connection.
- Many fixes to pptp-command.  Most importantly, it now runs with -T.
* Sat Dec 16 2000 Scott Venier <scott.venier@compaq.com>
- Fixed a bug in Delete A CHAP Secret so that it actually works now.
* Wed Dec 06 2000 Scott Venier <scott.venier@compaq.com>
- make pptp-command behave properly when used as an init script.  Help from Tad Truex.
- sets itself up to stop the tunnel on any change in runlevel.
- added a default tunnel that gets used if run as 'pptp-command start'
* Wed Nov 29 2000 Scott Venier <scott.venier@compaq.com>
- fixed potiential name collisions between configs in different drop-in files
- "Delete a CHAP secret" now works
* Mon Nov 13 2000 Scott Venier <scott.venier@compaq.com>
- accidentally build -4 on a redhat 7 box instead of 6.2
* Sun Nov 05 2000 Scott Venier <scott.venier@compaq.com>
- add support for /etc/pptp.d/ config files
- add a main menu to pptp-command
- removed the unneeded pptp_callmgr
* Fri Nov 03 2000 Scott Venier <scott.venier@compaq.com>
- combine in a single perl script that replaces pptp-scripts

%prep
%setup -q
#%patch0 -p1
#for f in debian/*.dpatch; do
#    patch -p2 < $f
#done
#%patch1 -p1

%build
make

%install
mkdir -p $RPM_BUILD_ROOT/usr/sbin
mkdir -p $RPM_BUILD_ROOT/usr/man/man8
mkdir -p $RPM_BUILD_ROOT/etc/ppp
mkdir -p $RPM_BUILD_ROOT/etc/pptp.d
mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d/
cp pptp $RPM_SOURCE_DIR/pptp-command $RPM_BUILD_ROOT/usr/sbin
cp $RPM_SOURCE_DIR/options.pptp $RPM_BUILD_ROOT/etc/ppp
gzip -c9 debian/pptp.8 > $RPM_BUILD_ROOT/usr/man/man8/pptp.8.gz
pwd

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ -d /etc/init.d ]; then
	RPM_INIT_DIR=/etc/init.d
elif [ -d /etc/rc.d/init.d ]; then
	RPM_INIT_DIR=/etc/rc.d/init.d
fi
ln -s /usr/sbin/pptp-command $RPM_INIT_DIR/pptp
if [ -x /usr/lib/lsb/install_initd ]; then
	/usr/lib/lsb/install_initd $RPM_INIT_DIR/pptp
elif [ -x /lib/lsb/install_initd ]; then
	/lib/lsb/install_initd $RPM_INIT_DIR/pptp
elif [ -x /sbin/chkconfig ]; then
	/sbin/chkconfig pptp reset
fi

%files
%defattr(0644,root,root,0755)
%doc AUTHORS COPYING INSTALL NEWS README TODO USING Documentation Reference
%doc debian/README.Debian debian/README.Reference 
%doc debian/changelog debian/copyright

%attr(0755,root,root) /usr/sbin/pptp
%attr(0444,root,root) /usr/man/man8/pptp.8.gz
%attr(0755,root,root) /usr/sbin/pptp-command
%config %attr(0600,root,root) /etc/ppp/options.pptp
%attr(0755,root,root) /etc/pptp.d
