-- A test program by Jens Petersen <juhp@01.246.ne.jp>
-- Runs as: ./TestProcesses cat <data
-- where `data' should contain at least 4096 bytes

module Main
where

import HPL

main :: IO()
main = 
  do
   inpt <- getContents
   withPorts [] $ \ (cmd:args) ->
     do
       (outpt, errpt) <- spawn2_ $ \out err ->
	 do
	   putStrLn "output:"
	   mapM_ putStrLn $ lines out
	   putStrLn "error:"
	   putStr err
       let p = proc cmd args
       p inpt outpt errpt
       waitForThread errpt
       putStrLn "test finished"
