-- simple remote evaluation test

import Monad
import HPL

server :: IO ()
server  = do
  ps <- listenToNamedPort "ping-pong"
  -- entspricht:
  --   p <- newPort undefined
  --   "ping-pong" <<-> p
  --   ps <- listenToPort p

  mapM_ (getEnv "HOST" >>= (p <--)) ps

main :: IO ()
main  = do
  initDistributedPorts Nothing [("server", server)]
  serverPort <- newPort undefined
  serverPort `named` "ping-pong"
  "enki" `hosts` "server"
  listened serverPort				-- wait until connected

  let timePing p = do
	putStr $ "Pinging " ++ show p ++ " ... "
	(name, ms) <- timeit $ pingPong p
	putStrLn $ "at " ++ name ++ " time=" ++ show ms ++ "ms"
      pingPong p = do
        clientPort <- newPort undefined
	answers <- listenToPort clientPort
	p <-- Ping clientPort
	let Pong name:_ = answers
	return name

  mapM_ timePing (replicate 4 serverPort)
  closePort serverPort	   -- to unregister it

{- evtl sowas wie

main  = distributedPorts Nothing [("server", server)] $ \args -> do
  ...
  ...

if that argument to `distributedPorts' is forkIOed, it is easier to
prevent program termination until the HPL allows the program to terminate

Maybe call it `withPorts' and use it in distributed and non-distributed mode,
where `args' are the arguments after the HPL stripped off what it needed

Maybe we can remove the `Nothing' argument and require that the HPL is always
the first to get to see the arguments; for a distributed execution that may
actually be necessary anyway.

-}
