-- simple test of port interface

import HPL

agent1 po = po <== [5, 4, 6]

agent2 po = po <-$ (+ 1)

main :: IO ()
main  = do
	  po <- 0 `spawn` print
	  (agent1 po & agent2 po) >> closePort po

{- OLD version
main :: IO ()
main  = do
	  po <- newPort 0
	  vs <- listenToPort po
	  (agent1 po & agent2 po) >> closePort po
	  print vs
-}

-- This deadlocks, as the demand induced by `print vs' floats up before some
-- of the code that fills/closes the port; hence, the latter is never reached
-- (as the thread suspends due to the floated demand).
