import Monad
import HPL

otherHost :: String
otherHost  = "enki"

data ServerMsg = Ping (Port ClientMsg)
	       deriving (Show, Read)
data ClientMsg = Pong String
	       deriving (Show, Read)

main :: IO ()
main  = do
  serverPort <- newPort undefined
  serverPort `named` "ping-pong"
  rproc otherHost "PingClient" []
  listened serverPort			-- wait until connected

  let timePing p = do
	putStr $ "Pinging " ++ show p ++ " ... "
	(name, ms) <- timeit $ pingPong p
	putStrLn $ "at " ++ name ++ " time=" ++ show ms ++ "ms"
      pingPong p = do
        clientPort <- newPort undefined
	answers <- listenToPort clientPort
	p <-- Ping clientPort
	let Pong name:_ = answers
	return name

  mapM_ timePing (replicate 4 serverPort)
  closePort serverPort	   -- to unregister it
