#  The Haskell Ports Library: Common makefile definitions
#
#  Author : Manuel M. T. Chakravarty
#  Derived: 24 May 2000
#
#  Version $Revision: 1.3 $ from $Date: 2001/07/02 07:39:47 $
#
#  Copyright (c) 2000 Manuel M. T. Chakravarty
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Library General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
#
#  = DOCU =====================================================================
#
#  * Derived from the corresponding Gtk+HS file.
#

#  ***************************************
#  !!! This makefile requires GNU make !!!
#  ***************************************

# GNU make trickery
#
empty:=
space:= $(empty) $(empty)

# mkdepend for Haskell
#
# * $(MAKEDEPEXCL) should contain a list of directories that should be 
#   excluded from the generated dependencies; furthermore, all imports from
#   C->HS supplied modules are excluded
#
MKDEPENDHS  = $(HC) -M -optdep-f -optdep$(DEPEND)
MKDEPFLAGS  = $(HCFLAGS)
MKDEPEXCLOPT= $(addprefix -optdep-X, $(MKDEPEXCL))

# Name of dependency file
#
DEPEND=.depend

# always execute the `default' target if none is given
#
.PHONY: firsttarget
firsttarget: default

# Generic rules for computing module dependencies
#
.PHONY: gendepend
gendepend:
	$(MKDEPENDHS) $(MKDEPFLAGS) $(MKDEPEXCLOPT)\
	  $(filter %.hs,$(SRCS) $(GENSRCS))


# Generic rules for compiling Haskell files
#

%.o: %.hs
	-$(RM) $@
	$(HC) -c $< $(HCFLAGS) $($(join $<,-HCFLAGS))
%.hi: %.o
	@:

# Generic rules for linking Haskell files
#
%: %.o
	-$(RM) $@
	$(HC) -o $@ $(HCFLAGS) $(HLDFLAGS) $<

# Generic auxilliary targets
#
.PHONY: genclean genspotless

genclean:
	-$(RM) *.o $(GENSRCS)

genspotless: clean
	-$(RM) *.hi .depend
