/*
** pork_set.h - /SET command implementation.
** Copyright (C) 2002-2003 Ryan McCabe <ryan@numb.org>
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License, version 2,
** as published by the Free Software Foundation.
*/

#ifndef __PORK_SET_H
#define __PORK_SET_H

#define OPT_INT				0
#define OPT_CHAR			1
#define OPT_STR				2
/* OPT_FORMAT is functionally identical to OPT_STRING */
#define OPT_FORMAT			2
#define OPT_BOOL			3
#define OPT_COLOR			4

/*
** Default values for the global options.
*/

#define DEFAULT_AUTO_RECONNECT				1
#define DEFAULT_AUTOSEND_AWAY				0
#define DEFAULT_BANNER						"*** "
#define DEFAULT_BEEP_ON_OUTPUT				0
#define DEFAULT_CMDCHARS					'/'
#define DEFAULT_COLOR_BLIST_FOCUS			0x200400
#define DEFAULT_COLOR_BLIST_NOFOCUS			0x200500
#define DEFAULT_COLOR_BLIST_SELECTOR		0x202400
#define DEFAULT_DOWNLOAD_DIR				""
#define DEFAULT_FORMAT_BLIST				" $B $N$>$i"
#define DEFAULT_FORMAT_BLIST_GROUP			"($E) $N ($O/$T)"
#define DEFAULT_FORMAT_BLIST_IDLE			"%B$I"
#define DEFAULT_FORMAT_BLIST_WARN			"$W%%"
#define DEFAULT_FORMAT_CHAT_CREATE			"%W$N%x has %Gcreated %C$R %D(%x$M%D)%x"
#define DEFAULT_FORMAT_CHAT_IGNORE			"%W$N%x has %Gignored%x $U in %C$R%x"
#define DEFAULT_FORMAT_CHAT_INFO			"%W$N%x has $A %C$R%x"
#define DEFAULT_FORMAT_CHAT_INVITE			"%W$N%x has %Ginvited%x $U to %C$R%x %D(%x$M%D)%x"
#define DEFAULT_FORMAT_CHAT_KICK			"%W$N%x has %Gkicked%x $U from %C$R%x %D(%x$M%D)%x"
#define DEFAULT_FORMAT_CHAT_RECV			"%b<%x$N%b>%x $M"
#define DEFAULT_FORMAT_CHAT_RECV_NOTICE		"%D-%B$N%Y:%b$C%D-%x $M"
#define DEFAULT_FORMAT_CHAT_SEND			"$C%m>%x $M"
#define DEFAULT_FORMAT_CHAT_SEND_NOTICE		"%D-> -%c$N%Y:%b$C%D-%x $M"
#define DEFAULT_FORMAT_CHAT_TOPIC			"%W$N%x has set the topic for %C$C%x to%W:%x $M"
#define DEFAULT_FORMAT_CHAT_UNIGNORE		"%W$N%x has %Gunignored%x $U in %C$R%x"
#define DEFAULT_FORMAT_FILE_RECV_ACCEPT		"$U has accepted $N from $u. Beginning transfer"
#define DEFAULT_FORMAT_FILE_RECV_ASK		"$u [$F:$p] wants to send $N ($S bytes) to $U. Type /file get $I to accept it"
#define DEFAULT_FORMAT_FILE_RECV_COMPLETE	"Transfer $I has completed successfully: $N ($S bytes) was successfully received by $U from $u in $T seconds ($R KB/s)"
#define DEFAULT_FORMAT_FILE_SEND_ACCEPT		"$u [$F:$p] has accepted $N from $U. Beginning transfer"
#define DEFAULT_FORMAT_FILE_SEND_ASK		"Sent request to send $N ($S bytes) from $u to $U, waiting for reply"
#define DEFAULT_FORMAT_FILE_SEND_COMPLETE	"Transfer $I has completed successfully: $N ($S bytes) was successfully by $U to $u in $T seconds ($R KB/s)"
#define DEFAULT_FORMAT_IM_RECV				"%m<%x$N%m>%x $M"
#define DEFAULT_FORMAT_IM_RECV_AUTO			"%Ca%cuto%D-%Cr%cesponse%x from %W$N%D:%x $M"
#define DEFAULT_FORMAT_IM_SEND				"%c>%x $M"
#define DEFAULT_FORMAT_IM_SEND_AUTO			"%Ca%cuto%D-%Cr%cesponse%x to %W$R%D:%x $M"
#define DEFAULT_FORMAT_NOTICE_RECV			"%D-%B$N%D-%x $M"
#define DEFAULT_FORMAT_NOTICE_SEND			"%D-> -%c$R%D-%x $M"
#define DEFAULT_FORMAT_STATUS				"%d,w$T $n [$z$c]$A$Y$H $>$I$W%d,w -%m,wp%x%d,work-"
#define DEFAULT_FORMAT_STATUS_ACTIVITY		" %w,d{$A}%d,w"
#define DEFAULT_FORMAT_STATUS_HELD			" <%g,w$H%d,w>"
#define DEFAULT_FORMAT_STATUS_IDLE			"%d,w (%D,widle: $i%d,w)"
#define DEFAULT_FORMAT_STATUS_TIMESTAMP		"[ $H:$m]"
#define DEFAULT_FORMAT_STATUS_TYPING		" (%b,w$Y%d,w)"
#define DEFAULT_FORMAT_STATUS_WARN			"%d,w [%r,w$w%%%d,w]%x"
#define DEFAULT_FORMAT_WARN					"%R$N%r has been warned by %R$U%r.%x Warning level is now %W$W%%%x."
#define DEFAULT_HISTORY_LEN					400
#define DEFAULT_IDLE_AFTER					10
#define DEFAULT_LOG							0
#define DEFAULT_LOGIN_ON_STARTUP			1
#define DEFAULT_PORK_DIR					NULL
#define DEFAULT_PRIVATE_INPUT				0
#define DEFAULT_PROMPT						"%Mp%mork%w>%x "
#define DEFAULT_RECURSIVE_EVENTS			0
#define DEFAULT_REPORT_IDLE					1
#define DEFAULT_SAVE_PASSWD					0
#define DEFAULT_SCROLL_ON_INPUT				1
#define DEFAULT_SCROLL_ON_OUTPUT			0
#define DEFAULT_SCROLLBUF_LEN				5000
#define DEFAULT_SEND_REMOVES_AWAY			1
#define DEFAULT_SHOW_BLIST					0
#define DEFAULT_SHOW_BUDDY_AWAY				1
#define DEFAULT_SHOW_BUDDY_IDLE				0
#define DEFAULT_SHOW_BUDDY_SIGNOFF			1
#define DEFAULT_TEXT_BLIST_GROUP_EXPANDED	"%B+%x"
#define DEFAULT_TEXT_BLIST_GROUP_COLLAPSED	"%R-%x"
#define	DEFAULT_TEXT_BUDDY_ACTIVE			"%G*%x"
#define DEFAULT_TEXT_BUDDY_AWAY				"%r*%x"
#define DEFAULT_TEXT_BUDDY_IDLE				"%Y*%x"
#define DEFAULT_TEXT_CHAT_JOIN				"%Gjoined%x"
#define DEFAULT_TEXT_CHAT_LEAVE				"%rleft%x"
#define DEFAULT_TEXT_NO_NAME				"<not specified>"
#define DEFAULT_TEXT_NO_ROOM				":(not joined)"
#define DEFAULT_TEXT_TYPING					"Typing"
#define DEFAULT_TEXT_TYPING_PAUSED			"Typing [paused]"
#define DEFAULT_TEXT_WARN_ANONYMOUS			"%D<%ranonymous%D>%x"
#define DEFAULT_TIMESTAMP					1

#define opt_set_format	opt_set_str

/*
** Global options.
*/

enum {
	OPT_AUTO_RECONNECT = 0,
	OPT_AUTOSEND_AWAY,
	OPT_BANNER,
	OPT_BEEP_ON_OUTPUT,
	OPT_CMDCHARS,
	OPT_COLOR_BLIST_FOCUS,
	OPT_COLOR_BLIST_NOFOCUS,
	OPT_COLOR_BLIST_SELECTOR,
	OPT_DOWNLOAD_DIR,
	OPT_FORMAT_BLIST,
	OPT_FORMAT_BLIST_GROUP,
	OPT_FORMAT_BLIST_IDLE,
	OPT_FORMAT_BLIST_WARN,
	OPT_FORMAT_CHAT_CREATE,
	OPT_FORMAT_CHAT_IGNORE,
	OPT_FORMAT_CHAT_INFO,
	OPT_FORMAT_CHAT_INVITE,
	OPT_FORMAT_CHAT_KICK,
	OPT_FORMAT_CHAT_RECV,
	OPT_FORMAT_CHAT_RECV_NOTICE,
	OPT_FORMAT_CHAT_SEND,
	OPT_FORMAT_CHAT_SEND_NOTICE,
	OPT_FORMAT_CHAT_TOPIC,
	OPT_FORMAT_CHAT_UNIGNORE,
	OPT_FORMAT_FILE_RECV_ACCEPT,
	OPT_FORMAT_FILE_RECV_ASK,
	OPT_FORMAT_FILE_RECV_COMPLETE,
	OPT_FORMAT_FILE_SEND_ACCEPT,
	OPT_FORMAT_FILE_SEND_ASK,
	OPT_FORMAT_FILE_SEND_COMPLETE,
	OPT_FORMAT_IM_RECV,
	OPT_FORMAT_IM_RECV_AUTO,
	OPT_FORMAT_IM_SEND,
	OPT_FORMAT_IM_SEND_AUTO,
	OPT_FORMAT_NOTICE_RECV,
	OPT_FORMAT_NOTICE_SEND,
	OPT_FORMAT_STATUS,
	OPT_FORMAT_STATUS_ACTIVITY,
	OPT_FORMAT_STATUS_HELD,
	OPT_FORMAT_STATUS_IDLE,
	OPT_FORMAT_STATUS_TIMESTAMP,
	OPT_FORMAT_STATUS_TYPING,
	OPT_FORMAT_STATUS_WARN,
	OPT_FORMAT_WARN,
	OPT_HISTORY_LEN,
	OPT_IDLE_AFTER,
	OPT_LOG,
	OPT_LOGIN_ON_STARTUP,
	OPT_PORK_DIR,
	OPT_PRIVATE_INPUT,
	OPT_PROMPT,
	OPT_RECURSIVE_EVENTS,
	OPT_REPORT_IDLE,
	OPT_SAVE_PASSWD,
	OPT_SCROLL_ON_INPUT,
	OPT_SCROLL_ON_OUTPUT,
	OPT_SCROLLBUF_LEN,
	OPT_SEND_REMOVES_AWAY,
	OPT_SHOW_BLIST,
	OPT_SHOW_BUDDY_AWAY,
	OPT_SHOW_BUDDY_IDLE,
	OPT_SHOW_BUDDY_SIGNOFF,
	OPT_TEXT_BLIST_GROUP_COLLAPSED,
	OPT_TEXT_BLIST_GROUP_EXPANDED,
	OPT_TEXT_BUDDY_ACTIVE,
	OPT_TEXT_BUDDY_AWAY,
	OPT_TEXT_BUDDY_IDLE,
	OPT_TEXT_CHAT_JOIN,
	OPT_TEXT_CHAT_LEAVE,
	OPT_TEXT_NO_NAME,
	OPT_TEXT_NO_ROOM,
	OPT_TEXT_TYPING,
	OPT_TEXT_TYPING_PAUSED,
	OPT_TEXT_WARN_ANONYMOUS,
	OPT_TIMESTAMP,
	OPT_NUM_OPTS
};

#define OPT_FORMAT_OFFSET OPT_FORMAT_BLIST

extern struct global_var global_var[OPT_NUM_OPTS];

/*
** Per-window options.
*/

enum {
	WOPT_BEEP_ON_OUTPUT = 0,
	WOPT_HISTORY_LEN,
	WOPT_LOG,
	WOPT_LOGFILE,
	WOPT_PRIVATE_INPUT,
	WOPT_SCROLL_ON_INPUT,
	WOPT_SCROLL_ON_OUTPUT,
	WOPT_SCROLLBUF_LEN,
	WOPT_SHOW_BLIST,
	WOPT_TIMESTAMP,
	WOPT_NUM_OPTS
};

struct imwindow;

struct global_var {
	char *name;
	u_int32_t type:31;
	u_int32_t dynamic:1;
	int (*set)(u_int32_t, char *);
	void (*updated)(void);
	union {
		u_int32_t i;
		u_int32_t b;
		char c;
		char *s;
	} val;
};

struct window_opts {
	union {
		u_int32_t i;
		u_int32_t b;
		char c;
		char *s;
	} val;
};

struct window_var {
	char *name;
	u_int32_t type;
	int (*set)(struct imwindow *, u_int32_t, char *);
	void (*updated)(struct imwindow *);
};

#define SET_STR(x)	{ .s = (x) }
#define SET_INT(x)	{ .i = (x) }
#define SET_CHAR(x)	{ .c = (x) }
#define SET_BOOL(x)	{ .b = (x) }

void opt_destroy(void);
void wopt_init(struct imwindow *imwindow, const char *target);
void wopt_destroy(struct imwindow *imwindow);

void wopt_print_var(struct imwindow *win, int var, const char *text);
void wopt_print(struct imwindow *win);

void opt_print_var(int var, const char *text);
void opt_print(void);
void opt_write(FILE *fp);

int opt_set(u_int32_t opt, char *args);
int wopt_set(struct imwindow *imwindow, u_int32_t opt, char *args);

int opt_find(const char *name);
int wopt_find(const char *name);

int opt_get_val(const char *opt_name, char *buf, size_t len);
int wopt_get_val(	struct imwindow *imwindow,
					const char *opt_name,
					char *buf,
					size_t len);

/*
** These used to be inline functions until I discovered
** how positively stupid GCC is. GCC refused to inline
** the functions regardless of which one of the 9 or 10
** possible ways to tell it "inline this" I used.
*/

#define opt_get_int(opt) (global_var[(opt)].val.i)
#define opt_get_color(opt) (global_var[(opt)].val.i)
#define opt_get_bool(opt) (global_var[(opt)].val.b)
#define opt_get_char(opt) (global_var[(opt)].val.c)
#define opt_get_str(opt) (global_var[(opt)].val.s)

#define wopt_get_int(wopt, opt) ((wopt)[(opt)].val.i)
#define wopt_get_str(wopt, opt) ((wopt)[(opt)].val.s)
#define wopt_get_char(wopt, opt) ((wopt)[(opt)].val.c)
#define wopt_get_bool(wopt, opt) ((wopt)[(opt)].val.b)

#endif
