/* Copyright 1993-95 by Carl Harris, Jr.
 * All rights reserved
 *
 * Distribute freely, except: don't remove my name from the source or
 * documentation (don't take credit for my work), mark your changes (don't
 * get me blamed for your possible bugs), don't alter or remove this
 * notice.  May be sold if buildable source is provided to buyer.  No
 * warrantee of any kind, express or implied, is included with this
 * software; use at your own risk, responsibility for damages (if any) to
 * anyone resulting from the use of this software rests entirely with the
 * user.
 *
 * Send bug reports, bug fixes, enhancements, requests, flames, etc., and
 * I'll try to keep a version up to date.  I can be reached as follows:
 * Carl Harris <ceharris@mal.com>
 */


/***********************************************************************
  module:       socket.h
  project:      popclient
  programmer:   Carl Harris, ceharris@mal.com
  description:  declarations for socket library functions

  $Log: socket.h,v $
  Revision 1.2  1995/08/08 01:01:39  ceharris
  Added GNU-style long options processing.
  Fixed password in 'ps' output problem.
  Fixed various RCS tag blunders.
  Integrated .poprc parser, lexer, etc into Makefile processing.

 ***********************************************************************/

#ifndef SOCKET__
#define SOCKET__

#ifndef  INADDR_NONE
#ifdef   INADDR_BROADCAST
#define  INADDR_NONE	INADDR_BROADCAST
#else
#define	 INADDR_NONE	-1
#endif
#endif

#if defined(HAVE_PROTOTYPES)
/*
Create a new client socket 
returns < 0 on error 
*/
int Socket(char *host, int clientPort);

/* 
Get a string terminated by an '\n', delete any '\r' and the '\n'.
Pass it a valid socket, a buffer for the string, and
the length of the buffer (including the trailing \0)
returns 0 for success. 
*/
int SockGets(int socket, char *buf, int len);

/*
Send a nul terminated string to the socket, followed by 
a CR-LF.  Returns 0 for success.
*/
int SockPuts(int socket, char *buf);

/*
Write a chunk of bytes to the socket.
Returns 0 for success.
*/
int SockWrite(int socket, char *buf, int len);

/*
Read a chunk of bytes from the socket.
Returns 0 for success.
*/
int SockRead(int socket, char *buf, int len);

/* 
Send formatted output to the socket, followed
by a CR-LF.
Returns 0 for success.
*/
int SockPrintf();

/*
Check socket for readability.  return 0 for not readable,
>0 for readable.
*/
int SockStatus(int socket, int seconds);
 
#endif /* defined(HAVE_PROTOTYPES) */

#endif /* SOCKET__ */
