/*
	in.pop3gwd, a POP3 proxy
	Copyright (C) 1997 Andrea Borgia

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* relay_data.c: move data between two sockets */
/* ------------------------------------------- */

#include "pop3-gw.h"



void relay_data(int first_filedes, int second_filedes, int maxwait, int *in, int *out) {
        fd_set  master, copy;
	struct timeval	deadline;
	int logged_in = TRUE;
	int count;
	char buf[MAX_IO_LEN];


	FD_ZERO(&master);
	FD_SET(first_filedes, &master);
	FD_SET(second_filedes, &master);	

	while (logged_in == TRUE) {
	
		bcopy(&master, &copy, sizeof(fd_set));  /* select() trashes copy */
		deadline.tv_sec = maxwait;
		deadline.tv_usec = 0;

		if (select(MAX(first_filedes, second_filedes)+1, &copy, (fd_set *)NULL, (fd_set *)NULL, &deadline) <= 0) {
#ifdef DEBUG
			syslog(LOG_PRIO, "Network timeout signal after %d seconds while relaying data", maxwait);
#endif
			logged_in = FALSE;
		}
		else {
			if (FD_ISSET(first_filedes, &copy)) {
				if ((count = read(first_filedes, buf, sizeof(buf))) <= 0)
					logged_in = FALSE;
				else 
					if (writen(second_filedes, buf, count, maxwait) == count)
						(*out) += count;
					else
						logged_in = FALSE;
			}
			if (FD_ISSET(second_filedes, &copy) && logged_in == TRUE) {
				if ((count = read(second_filedes, buf, sizeof(buf))) <= 0)
					logged_in = FALSE;
				else
					if (writen(first_filedes, buf, count, maxwait) == count)
						(*in) += count;
					else
						logged_in = FALSE;
			}
		}
	}
}
